/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLifecycleHooksRequestMarshaller
implements Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {
    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        if (describeLifecycleHooksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLifecycleHooksRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        if (describeLifecycleHooksRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeLifecycleHooksRequest.getAutoScalingGroupName()));
        }
        List<String> lifecycleHookNamesList = describeLifecycleHooksRequest.getLifecycleHookNames();
        int lifecycleHookNamesListIndex = 1;
        for (String lifecycleHookNamesListValue : lifecycleHookNamesList) {
            if (lifecycleHookNamesListValue != null) {
                request.addParameter("LifecycleHookNames.member." + lifecycleHookNamesListIndex, StringUtils.fromString((String)lifecycleHookNamesListValue));
            }
            ++lifecycleHookNamesListIndex;
        }
        return request;
    }
}

