/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.DateRange;
import java.util.Date;

@SdkInternalApi
public class DateRangeMarshaller {
    private static final MarshallingInfo<Date> FROMDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> TODATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToDate").timestampFormat("unixTimestamp").build();
    private static final DateRangeMarshaller instance = new DateRangeMarshaller();

    public static DateRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(DateRange dateRange, ProtocolMarshaller protocolMarshaller) {
        if (dateRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dateRange.getFromDate(), FROMDATE_BINDING);
            protocolMarshaller.marshall((Object)dateRange.getToDate(), TODATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

