/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.BudgetType;
import com.amazonaws.services.budgets.model.BudgetedAndActualAmounts;
import com.amazonaws.services.budgets.model.CostTypes;
import com.amazonaws.services.budgets.model.TimeUnit;
import com.amazonaws.services.budgets.model.transform.BudgetPerformanceHistoryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BudgetPerformanceHistory
implements Serializable,
Cloneable,
StructuredPojo {
    private String budgetName;
    private String budgetType;
    private Map<String, List<String>> costFilters;
    private CostTypes costTypes;
    private String timeUnit;
    private List<BudgetedAndActualAmounts> budgetedAndActualAmountsList;

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public BudgetPerformanceHistory withBudgetName(String budgetName) {
        this.setBudgetName(budgetName);
        return this;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public String getBudgetType() {
        return this.budgetType;
    }

    public BudgetPerformanceHistory withBudgetType(String budgetType) {
        this.setBudgetType(budgetType);
        return this;
    }

    public BudgetPerformanceHistory withBudgetType(BudgetType budgetType) {
        this.budgetType = budgetType.toString();
        return this;
    }

    public Map<String, List<String>> getCostFilters() {
        return this.costFilters;
    }

    public void setCostFilters(Map<String, List<String>> costFilters) {
        this.costFilters = costFilters;
    }

    public BudgetPerformanceHistory withCostFilters(Map<String, List<String>> costFilters) {
        this.setCostFilters(costFilters);
        return this;
    }

    public BudgetPerformanceHistory addCostFiltersEntry(String key, List<String> value) {
        if (null == this.costFilters) {
            this.costFilters = new HashMap<String, List<String>>();
        }
        if (this.costFilters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.costFilters.put(key, value);
        return this;
    }

    public BudgetPerformanceHistory clearCostFiltersEntries() {
        this.costFilters = null;
        return this;
    }

    public void setCostTypes(CostTypes costTypes) {
        this.costTypes = costTypes;
    }

    public CostTypes getCostTypes() {
        return this.costTypes;
    }

    public BudgetPerformanceHistory withCostTypes(CostTypes costTypes) {
        this.setCostTypes(costTypes);
        return this;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public BudgetPerformanceHistory withTimeUnit(String timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public BudgetPerformanceHistory withTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit.toString();
        return this;
    }

    public List<BudgetedAndActualAmounts> getBudgetedAndActualAmountsList() {
        return this.budgetedAndActualAmountsList;
    }

    public void setBudgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> budgetedAndActualAmountsList) {
        if (budgetedAndActualAmountsList == null) {
            this.budgetedAndActualAmountsList = null;
            return;
        }
        this.budgetedAndActualAmountsList = new ArrayList<BudgetedAndActualAmounts>(budgetedAndActualAmountsList);
    }

    public BudgetPerformanceHistory withBudgetedAndActualAmountsList(BudgetedAndActualAmounts ... budgetedAndActualAmountsList) {
        if (this.budgetedAndActualAmountsList == null) {
            this.setBudgetedAndActualAmountsList(new ArrayList<BudgetedAndActualAmounts>(budgetedAndActualAmountsList.length));
        }
        for (BudgetedAndActualAmounts ele : budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList.add(ele);
        }
        return this;
    }

    public BudgetPerformanceHistory withBudgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> budgetedAndActualAmountsList) {
        this.setBudgetedAndActualAmountsList(budgetedAndActualAmountsList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBudgetName() != null) {
            sb.append("BudgetName: ").append(this.getBudgetName()).append(",");
        }
        if (this.getBudgetType() != null) {
            sb.append("BudgetType: ").append(this.getBudgetType()).append(",");
        }
        if (this.getCostFilters() != null) {
            sb.append("CostFilters: ").append(this.getCostFilters()).append(",");
        }
        if (this.getCostTypes() != null) {
            sb.append("CostTypes: ").append(this.getCostTypes()).append(",");
        }
        if (this.getTimeUnit() != null) {
            sb.append("TimeUnit: ").append(this.getTimeUnit()).append(",");
        }
        if (this.getBudgetedAndActualAmountsList() != null) {
            sb.append("BudgetedAndActualAmountsList: ").append(this.getBudgetedAndActualAmountsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetPerformanceHistory)) {
            return false;
        }
        BudgetPerformanceHistory other = (BudgetPerformanceHistory)obj;
        if (other.getBudgetName() == null ^ this.getBudgetName() == null) {
            return false;
        }
        if (other.getBudgetName() != null && !other.getBudgetName().equals(this.getBudgetName())) {
            return false;
        }
        if (other.getBudgetType() == null ^ this.getBudgetType() == null) {
            return false;
        }
        if (other.getBudgetType() != null && !other.getBudgetType().equals(this.getBudgetType())) {
            return false;
        }
        if (other.getCostFilters() == null ^ this.getCostFilters() == null) {
            return false;
        }
        if (other.getCostFilters() != null && !other.getCostFilters().equals(this.getCostFilters())) {
            return false;
        }
        if (other.getCostTypes() == null ^ this.getCostTypes() == null) {
            return false;
        }
        if (other.getCostTypes() != null && !other.getCostTypes().equals(this.getCostTypes())) {
            return false;
        }
        if (other.getTimeUnit() == null ^ this.getTimeUnit() == null) {
            return false;
        }
        if (other.getTimeUnit() != null && !other.getTimeUnit().equals(this.getTimeUnit())) {
            return false;
        }
        if (other.getBudgetedAndActualAmountsList() == null ^ this.getBudgetedAndActualAmountsList() == null) {
            return false;
        }
        return other.getBudgetedAndActualAmountsList() == null || other.getBudgetedAndActualAmountsList().equals(this.getBudgetedAndActualAmountsList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBudgetName() == null ? 0 : this.getBudgetName().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetType() == null ? 0 : this.getBudgetType().hashCode());
        hashCode = 31 * hashCode + (this.getCostFilters() == null ? 0 : this.getCostFilters().hashCode());
        hashCode = 31 * hashCode + (this.getCostTypes() == null ? 0 : this.getCostTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTimeUnit() == null ? 0 : this.getTimeUnit().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetedAndActualAmountsList() == null ? 0 : this.getBudgetedAndActualAmountsList().hashCode());
        return hashCode;
    }

    public BudgetPerformanceHistory clone() {
        try {
            return (BudgetPerformanceHistory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetPerformanceHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

