/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.EndPoint;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RealtimeLogConfig
implements Serializable,
Cloneable {
    private String aRN;
    private String name;
    private Long samplingRate;
    private SdkInternalList<EndPoint> endPoints;
    private SdkInternalList<String> fields;

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public RealtimeLogConfig withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RealtimeLogConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSamplingRate(Long samplingRate) {
        this.samplingRate = samplingRate;
    }

    public Long getSamplingRate() {
        return this.samplingRate;
    }

    public RealtimeLogConfig withSamplingRate(Long samplingRate) {
        this.setSamplingRate(samplingRate);
        return this;
    }

    public List<EndPoint> getEndPoints() {
        if (this.endPoints == null) {
            this.endPoints = new SdkInternalList();
        }
        return this.endPoints;
    }

    public void setEndPoints(Collection<EndPoint> endPoints) {
        if (endPoints == null) {
            this.endPoints = null;
            return;
        }
        this.endPoints = new SdkInternalList(endPoints);
    }

    public RealtimeLogConfig withEndPoints(EndPoint ... endPoints) {
        if (this.endPoints == null) {
            this.setEndPoints((Collection<EndPoint>)new SdkInternalList(endPoints.length));
        }
        for (EndPoint ele : endPoints) {
            this.endPoints.add((Object)ele);
        }
        return this;
    }

    public RealtimeLogConfig withEndPoints(Collection<EndPoint> endPoints) {
        this.setEndPoints(endPoints);
        return this;
    }

    public List<String> getFields() {
        if (this.fields == null) {
            this.fields = new SdkInternalList();
        }
        return this.fields;
    }

    public void setFields(Collection<String> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new SdkInternalList(fields);
    }

    public RealtimeLogConfig withFields(String ... fields) {
        if (this.fields == null) {
            this.setFields((Collection<String>)new SdkInternalList(fields.length));
        }
        for (String ele : fields) {
            this.fields.add((Object)ele);
        }
        return this;
    }

    public RealtimeLogConfig withFields(Collection<String> fields) {
        this.setFields(fields);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSamplingRate() != null) {
            sb.append("SamplingRate: ").append(this.getSamplingRate()).append(",");
        }
        if (this.getEndPoints() != null) {
            sb.append("EndPoints: ").append(this.getEndPoints()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeLogConfig)) {
            return false;
        }
        RealtimeLogConfig other = (RealtimeLogConfig)obj;
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSamplingRate() == null ^ this.getSamplingRate() == null) {
            return false;
        }
        if (other.getSamplingRate() != null && !other.getSamplingRate().equals(this.getSamplingRate())) {
            return false;
        }
        if (other.getEndPoints() == null ^ this.getEndPoints() == null) {
            return false;
        }
        if (other.getEndPoints() != null && !other.getEndPoints().equals(this.getEndPoints())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || other.getFields().equals(this.getFields());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSamplingRate() == null ? 0 : this.getSamplingRate().hashCode());
        hashCode = 31 * hashCode + (this.getEndPoints() == null ? 0 : this.getEndPoints().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        return hashCode;
    }

    public RealtimeLogConfig clone() {
        try {
            return (RealtimeLogConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

