/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyCookiesConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyHeadersConfig;
import com.amazonaws.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig;
import com.amazonaws.services.cloudfront.model.QueryStringNames;
import com.amazonaws.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateOriginRequestPolicyRequestMarshaller
implements Marshaller<Request<UpdateOriginRequestPolicyRequest>, UpdateOriginRequestPolicyRequest> {
    public Request<UpdateOriginRequestPolicyRequest> marshall(UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) {
        if (updateOriginRequestPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateOriginRequestPolicyRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateOriginRequestPolicyRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)updateOriginRequestPolicyRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/origin-request-policy/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateOriginRequestPolicyRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            OriginRequestPolicyConfig originRequestPolicyConfig = updateOriginRequestPolicyRequest.getOriginRequestPolicyConfig();
            if (originRequestPolicyConfig != null) {
                OriginRequestPolicyQueryStringsConfig queryStringsConfig;
                OriginRequestPolicyCookiesConfig cookiesConfig;
                OriginRequestPolicyHeadersConfig headersConfig;
                xmlWriter.startElement("OriginRequestPolicyConfig");
                if (originRequestPolicyConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(originRequestPolicyConfig.getComment()).endElement();
                }
                if (originRequestPolicyConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(originRequestPolicyConfig.getName()).endElement();
                }
                if ((headersConfig = originRequestPolicyConfig.getHeadersConfig()) != null) {
                    Headers headers;
                    xmlWriter.startElement("HeadersConfig");
                    if (headersConfig.getHeaderBehavior() != null) {
                        xmlWriter.startElement("HeaderBehavior").value(headersConfig.getHeaderBehavior()).endElement();
                    }
                    if ((headers = headersConfig.getHeaders()) != null) {
                        SdkInternalList headersItemsList;
                        xmlWriter.startElement("Headers");
                        if (headers.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)headers.getQuantity()).endElement();
                        }
                        if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String headersItemsListValue : headersItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(headersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cookiesConfig = originRequestPolicyConfig.getCookiesConfig()) != null) {
                    CookieNames cookies;
                    xmlWriter.startElement("CookiesConfig");
                    if (cookiesConfig.getCookieBehavior() != null) {
                        xmlWriter.startElement("CookieBehavior").value(cookiesConfig.getCookieBehavior()).endElement();
                    }
                    if ((cookies = cookiesConfig.getCookies()) != null) {
                        SdkInternalList cookieNamesItemsList;
                        xmlWriter.startElement("Cookies");
                        if (cookies.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)cookies.getQuantity()).endElement();
                        }
                        if (!(cookieNamesItemsList = (SdkInternalList)cookies.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(cookieNamesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((queryStringsConfig = originRequestPolicyConfig.getQueryStringsConfig()) != null) {
                    QueryStringNames queryStrings;
                    xmlWriter.startElement("QueryStringsConfig");
                    if (queryStringsConfig.getQueryStringBehavior() != null) {
                        xmlWriter.startElement("QueryStringBehavior").value(queryStringsConfig.getQueryStringBehavior()).endElement();
                    }
                    if ((queryStrings = queryStringsConfig.getQueryStrings()) != null) {
                        SdkInternalList queryStringNamesItemsList;
                        xmlWriter.startElement("QueryStrings");
                        if (queryStrings.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)queryStrings.getQuantity()).endElement();
                        }
                        if (!(queryStringNamesItemsList = (SdkInternalList)queryStrings.getItems()).isEmpty() || !queryStringNamesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String queryStringNamesItemsListValue : queryStringNamesItemsList) {
                                xmlWriter.startElement("Name");
                                xmlWriter.value(queryStringNamesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

