/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.ResourceTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTagsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<ResourceTag> resourceTagList;
    private String nextToken;

    public List<ResourceTag> getResourceTagList() {
        if (this.resourceTagList == null) {
            this.resourceTagList = new ListWithAutoConstructFlag();
            this.resourceTagList.setAutoConstruct(true);
        }
        return this.resourceTagList;
    }

    public void setResourceTagList(Collection<ResourceTag> resourceTagList) {
        if (resourceTagList == null) {
            this.resourceTagList = null;
            return;
        }
        ListWithAutoConstructFlag resourceTagListCopy = new ListWithAutoConstructFlag(resourceTagList.size());
        resourceTagListCopy.addAll(resourceTagList);
        this.resourceTagList = resourceTagListCopy;
    }

    public ListTagsResult withResourceTagList(ResourceTag ... resourceTagList) {
        if (this.getResourceTagList() == null) {
            this.setResourceTagList(new ArrayList<ResourceTag>(resourceTagList.length));
        }
        for (ResourceTag value : resourceTagList) {
            this.getResourceTagList().add(value);
        }
        return this;
    }

    public ListTagsResult withResourceTagList(Collection<ResourceTag> resourceTagList) {
        if (resourceTagList == null) {
            this.resourceTagList = null;
        } else {
            ListWithAutoConstructFlag resourceTagListCopy = new ListWithAutoConstructFlag(resourceTagList.size());
            resourceTagListCopy.addAll(resourceTagList);
            this.resourceTagList = resourceTagListCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListTagsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceTagList() != null) {
            sb.append("ResourceTagList: " + this.getResourceTagList() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceTagList() == null ? 0 : this.getResourceTagList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResult)) {
            return false;
        }
        ListTagsResult other = (ListTagsResult)obj;
        if (other.getResourceTagList() == null ^ this.getResourceTagList() == null) {
            return false;
        }
        if (other.getResourceTagList() != null && !other.getResourceTagList().equals(this.getResourceTagList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListTagsResult clone() {
        try {
            return (ListTagsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

