/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPublicKeysRequestMarshaller
implements Marshaller<Request<ListPublicKeysRequest>, ListPublicKeysRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPublicKeysRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPublicKeysRequest> marshall(ListPublicKeysRequest listPublicKeysRequest) {
        if (listPublicKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPublicKeysRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.ListPublicKeys");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listPublicKeysRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(listPublicKeysRequest.getStartTime());
            }
            if (listPublicKeysRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(listPublicKeysRequest.getEndTime());
            }
            if (listPublicKeysRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listPublicKeysRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

