/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.EventSelector;
import com.amazonaws.services.cloudtrail.model.PutEventSelectorsRequest;
import com.amazonaws.services.cloudtrail.model.transform.EventSelectorJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutEventSelectorsRequestMarshaller
implements Marshaller<Request<PutEventSelectorsRequest>, PutEventSelectorsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutEventSelectorsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutEventSelectorsRequest> marshall(PutEventSelectorsRequest putEventSelectorsRequest) {
        if (putEventSelectorsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEventSelectorsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.PutEventSelectors");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList eventSelectorsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putEventSelectorsRequest.getTrailName() != null) {
                jsonGenerator.writeFieldName("TrailName").writeValue(putEventSelectorsRequest.getTrailName());
            }
            if (!(eventSelectorsList = (SdkInternalList)putEventSelectorsRequest.getEventSelectors()).isEmpty() || !eventSelectorsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EventSelectors");
                jsonGenerator.writeStartArray();
                for (EventSelector eventSelectorsListValue : eventSelectorsList) {
                    if (eventSelectorsListValue == null) continue;
                    EventSelectorJsonMarshaller.getInstance().marshall(eventSelectorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

