/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudtrail.model.DataResource;
import com.amazonaws.services.cloudtrail.model.ReadWriteType;
import com.amazonaws.services.cloudtrail.model.transform.EventSelectorMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EventSelector
implements Serializable,
Cloneable,
StructuredPojo {
    private String readWriteType;
    private Boolean includeManagementEvents;
    private SdkInternalList<DataResource> dataResources;
    private SdkInternalList<String> excludeManagementEventSources;

    public void setReadWriteType(String readWriteType) {
        this.readWriteType = readWriteType;
    }

    public String getReadWriteType() {
        return this.readWriteType;
    }

    public EventSelector withReadWriteType(String readWriteType) {
        this.setReadWriteType(readWriteType);
        return this;
    }

    public void setReadWriteType(ReadWriteType readWriteType) {
        this.withReadWriteType(readWriteType);
    }

    public EventSelector withReadWriteType(ReadWriteType readWriteType) {
        this.readWriteType = readWriteType.toString();
        return this;
    }

    public void setIncludeManagementEvents(Boolean includeManagementEvents) {
        this.includeManagementEvents = includeManagementEvents;
    }

    public Boolean getIncludeManagementEvents() {
        return this.includeManagementEvents;
    }

    public EventSelector withIncludeManagementEvents(Boolean includeManagementEvents) {
        this.setIncludeManagementEvents(includeManagementEvents);
        return this;
    }

    public Boolean isIncludeManagementEvents() {
        return this.includeManagementEvents;
    }

    public List<DataResource> getDataResources() {
        if (this.dataResources == null) {
            this.dataResources = new SdkInternalList();
        }
        return this.dataResources;
    }

    public void setDataResources(Collection<DataResource> dataResources) {
        if (dataResources == null) {
            this.dataResources = null;
            return;
        }
        this.dataResources = new SdkInternalList(dataResources);
    }

    public EventSelector withDataResources(DataResource ... dataResources) {
        if (this.dataResources == null) {
            this.setDataResources((Collection<DataResource>)new SdkInternalList(dataResources.length));
        }
        for (DataResource ele : dataResources) {
            this.dataResources.add((Object)ele);
        }
        return this;
    }

    public EventSelector withDataResources(Collection<DataResource> dataResources) {
        this.setDataResources(dataResources);
        return this;
    }

    public List<String> getExcludeManagementEventSources() {
        if (this.excludeManagementEventSources == null) {
            this.excludeManagementEventSources = new SdkInternalList();
        }
        return this.excludeManagementEventSources;
    }

    public void setExcludeManagementEventSources(Collection<String> excludeManagementEventSources) {
        if (excludeManagementEventSources == null) {
            this.excludeManagementEventSources = null;
            return;
        }
        this.excludeManagementEventSources = new SdkInternalList(excludeManagementEventSources);
    }

    public EventSelector withExcludeManagementEventSources(String ... excludeManagementEventSources) {
        if (this.excludeManagementEventSources == null) {
            this.setExcludeManagementEventSources((Collection<String>)new SdkInternalList(excludeManagementEventSources.length));
        }
        for (String ele : excludeManagementEventSources) {
            this.excludeManagementEventSources.add((Object)ele);
        }
        return this;
    }

    public EventSelector withExcludeManagementEventSources(Collection<String> excludeManagementEventSources) {
        this.setExcludeManagementEventSources(excludeManagementEventSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReadWriteType() != null) {
            sb.append("ReadWriteType: ").append(this.getReadWriteType()).append(",");
        }
        if (this.getIncludeManagementEvents() != null) {
            sb.append("IncludeManagementEvents: ").append(this.getIncludeManagementEvents()).append(",");
        }
        if (this.getDataResources() != null) {
            sb.append("DataResources: ").append(this.getDataResources()).append(",");
        }
        if (this.getExcludeManagementEventSources() != null) {
            sb.append("ExcludeManagementEventSources: ").append(this.getExcludeManagementEventSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSelector)) {
            return false;
        }
        EventSelector other = (EventSelector)obj;
        if (other.getReadWriteType() == null ^ this.getReadWriteType() == null) {
            return false;
        }
        if (other.getReadWriteType() != null && !other.getReadWriteType().equals(this.getReadWriteType())) {
            return false;
        }
        if (other.getIncludeManagementEvents() == null ^ this.getIncludeManagementEvents() == null) {
            return false;
        }
        if (other.getIncludeManagementEvents() != null && !other.getIncludeManagementEvents().equals(this.getIncludeManagementEvents())) {
            return false;
        }
        if (other.getDataResources() == null ^ this.getDataResources() == null) {
            return false;
        }
        if (other.getDataResources() != null && !other.getDataResources().equals(this.getDataResources())) {
            return false;
        }
        if (other.getExcludeManagementEventSources() == null ^ this.getExcludeManagementEventSources() == null) {
            return false;
        }
        return other.getExcludeManagementEventSources() == null || other.getExcludeManagementEventSources().equals(this.getExcludeManagementEventSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReadWriteType() == null ? 0 : this.getReadWriteType().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeManagementEvents() == null ? 0 : this.getIncludeManagementEvents().hashCode());
        hashCode = 31 * hashCode + (this.getDataResources() == null ? 0 : this.getDataResources().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeManagementEventSources() == null ? 0 : this.getExcludeManagementEventSources().hashCode());
        return hashCode;
    }

    public EventSelector clone() {
        try {
            return (EventSelector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

