/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.FileMetadata;

@SdkInternalApi
public class FileMetadataMarshaller {
    private static final MarshallingInfo<String> ABSOLUTEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("absolutePath").build();
    private static final MarshallingInfo<String> BLOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobId").build();
    private static final MarshallingInfo<String> FILEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileMode").build();
    private static final FileMetadataMarshaller instance = new FileMetadataMarshaller();

    public static FileMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileMetadata fileMetadata, ProtocolMarshaller protocolMarshaller) {
        if (fileMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileMetadata.getAbsolutePath(), ABSOLUTEPATH_BINDING);
            protocolMarshaller.marshall((Object)fileMetadata.getBlobId(), BLOBID_BINDING);
            protocolMarshaller.marshall((Object)fileMetadata.getFileMode(), FILEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

