/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codestar.model.Code;
import com.amazonaws.services.codestar.model.Toolchain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateProjectRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String id;
    private String description;
    private String clientRequestToken;
    private List<Code> sourceCode;
    private Toolchain toolchain;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateProjectRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public CreateProjectRequest withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateProjectRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateProjectRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public List<Code> getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(Collection<Code> sourceCode) {
        if (sourceCode == null) {
            this.sourceCode = null;
            return;
        }
        this.sourceCode = new ArrayList<Code>(sourceCode);
    }

    public CreateProjectRequest withSourceCode(Code ... sourceCode) {
        if (this.sourceCode == null) {
            this.setSourceCode(new ArrayList<Code>(sourceCode.length));
        }
        for (Code ele : sourceCode) {
            this.sourceCode.add(ele);
        }
        return this;
    }

    public CreateProjectRequest withSourceCode(Collection<Code> sourceCode) {
        this.setSourceCode(sourceCode);
        return this;
    }

    public void setToolchain(Toolchain toolchain) {
        this.toolchain = toolchain;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    public CreateProjectRequest withToolchain(Toolchain toolchain) {
        this.setToolchain(toolchain);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateProjectRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateProjectRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateProjectRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getSourceCode() != null) {
            sb.append("SourceCode: ").append(this.getSourceCode()).append(",");
        }
        if (this.getToolchain() != null) {
            sb.append("Toolchain: ").append(this.getToolchain()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getSourceCode() == null ^ this.getSourceCode() == null) {
            return false;
        }
        if (other.getSourceCode() != null && !other.getSourceCode().equals(this.getSourceCode())) {
            return false;
        }
        if (other.getToolchain() == null ^ this.getToolchain() == null) {
            return false;
        }
        if (other.getToolchain() != null && !other.getToolchain().equals(this.getToolchain())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getSourceCode() == null ? 0 : this.getSourceCode().hashCode());
        hashCode = 31 * hashCode + (this.getToolchain() == null ? 0 : this.getToolchain().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateProjectRequest clone() {
        return (CreateProjectRequest)super.clone();
    }
}

