/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.Scope;

public class ScopeJsonMarshaller {
    private static ScopeJsonMarshaller instance;

    public void marshall(Scope scope, StructuredJsonGenerator jsonGenerator) {
        if (scope == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList complianceResourceTypesList = (SdkInternalList)scope.getComplianceResourceTypes();
            if (!complianceResourceTypesList.isEmpty() || !complianceResourceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceResourceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceResourceTypesListValue : complianceResourceTypesList) {
                    if (complianceResourceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceResourceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (scope.getTagKey() != null) {
                jsonGenerator.writeFieldName("TagKey").writeValue(scope.getTagKey());
            }
            if (scope.getTagValue() != null) {
                jsonGenerator.writeFieldName("TagValue").writeValue(scope.getTagValue());
            }
            if (scope.getComplianceResourceId() != null) {
                jsonGenerator.writeFieldName("ComplianceResourceId").writeValue(scope.getComplianceResourceId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ScopeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ScopeJsonMarshaller();
        }
        return instance;
    }
}

