/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.Evaluation;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.transform.EvaluationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutEvaluationsRequestMarshaller
implements Marshaller<Request<PutEvaluationsRequest>, PutEvaluationsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutEvaluationsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutEvaluationsRequest> marshall(PutEvaluationsRequest putEvaluationsRequest) {
        if (putEvaluationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEvaluationsRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.PutEvaluations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList evaluationsList = (SdkInternalList)putEvaluationsRequest.getEvaluations();
            if (!evaluationsList.isEmpty() || !evaluationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Evaluations");
                jsonGenerator.writeStartArray();
                for (Evaluation evaluationsListValue : evaluationsList) {
                    if (evaluationsListValue == null) continue;
                    EvaluationJsonMarshaller.getInstance().marshall(evaluationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (putEvaluationsRequest.getResultToken() != null) {
                jsonGenerator.writeFieldName("ResultToken").writeValue(putEvaluationsRequest.getResultToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

