/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class StartConfigurationRecorderRequestMarshaller
implements Marshaller<Request<StartConfigurationRecorderRequest>, StartConfigurationRecorderRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public StartConfigurationRecorderRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartConfigurationRecorderRequest> marshall(StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        if (startConfigurationRecorderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startConfigurationRecorderRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.StartConfigurationRecorder");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startConfigurationRecorderRequest.getConfigurationRecorderName() != null) {
                jsonGenerator.writeFieldName("ConfigurationRecorderName").writeValue(startConfigurationRecorderRequest.getConfigurationRecorderName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

