/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.AgentContactReference;
import com.amazonaws.services.connect.model.AgentStatusReference;
import com.amazonaws.services.connect.model.HierarchyPathReference;
import com.amazonaws.services.connect.model.RoutingProfileReference;
import com.amazonaws.services.connect.model.UserReference;
import com.amazonaws.services.connect.model.transform.UserDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserData
implements Serializable,
Cloneable,
StructuredPojo {
    private UserReference user;
    private RoutingProfileReference routingProfile;
    private HierarchyPathReference hierarchyPath;
    private AgentStatusReference status;
    private Map<String, Integer> availableSlotsByChannel;
    private Map<String, Integer> maxSlotsByChannel;
    private Map<String, Integer> activeSlotsByChannel;
    private List<AgentContactReference> contacts;
    private String nextStatus;

    public void setUser(UserReference user) {
        this.user = user;
    }

    public UserReference getUser() {
        return this.user;
    }

    public UserData withUser(UserReference user) {
        this.setUser(user);
        return this;
    }

    public void setRoutingProfile(RoutingProfileReference routingProfile) {
        this.routingProfile = routingProfile;
    }

    public RoutingProfileReference getRoutingProfile() {
        return this.routingProfile;
    }

    public UserData withRoutingProfile(RoutingProfileReference routingProfile) {
        this.setRoutingProfile(routingProfile);
        return this;
    }

    public void setHierarchyPath(HierarchyPathReference hierarchyPath) {
        this.hierarchyPath = hierarchyPath;
    }

    public HierarchyPathReference getHierarchyPath() {
        return this.hierarchyPath;
    }

    public UserData withHierarchyPath(HierarchyPathReference hierarchyPath) {
        this.setHierarchyPath(hierarchyPath);
        return this;
    }

    public void setStatus(AgentStatusReference status) {
        this.status = status;
    }

    public AgentStatusReference getStatus() {
        return this.status;
    }

    public UserData withStatus(AgentStatusReference status) {
        this.setStatus(status);
        return this;
    }

    public Map<String, Integer> getAvailableSlotsByChannel() {
        return this.availableSlotsByChannel;
    }

    public void setAvailableSlotsByChannel(Map<String, Integer> availableSlotsByChannel) {
        this.availableSlotsByChannel = availableSlotsByChannel;
    }

    public UserData withAvailableSlotsByChannel(Map<String, Integer> availableSlotsByChannel) {
        this.setAvailableSlotsByChannel(availableSlotsByChannel);
        return this;
    }

    public UserData addAvailableSlotsByChannelEntry(String key, Integer value) {
        if (null == this.availableSlotsByChannel) {
            this.availableSlotsByChannel = new HashMap<String, Integer>();
        }
        if (this.availableSlotsByChannel.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.availableSlotsByChannel.put(key, value);
        return this;
    }

    public UserData clearAvailableSlotsByChannelEntries() {
        this.availableSlotsByChannel = null;
        return this;
    }

    public Map<String, Integer> getMaxSlotsByChannel() {
        return this.maxSlotsByChannel;
    }

    public void setMaxSlotsByChannel(Map<String, Integer> maxSlotsByChannel) {
        this.maxSlotsByChannel = maxSlotsByChannel;
    }

    public UserData withMaxSlotsByChannel(Map<String, Integer> maxSlotsByChannel) {
        this.setMaxSlotsByChannel(maxSlotsByChannel);
        return this;
    }

    public UserData addMaxSlotsByChannelEntry(String key, Integer value) {
        if (null == this.maxSlotsByChannel) {
            this.maxSlotsByChannel = new HashMap<String, Integer>();
        }
        if (this.maxSlotsByChannel.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.maxSlotsByChannel.put(key, value);
        return this;
    }

    public UserData clearMaxSlotsByChannelEntries() {
        this.maxSlotsByChannel = null;
        return this;
    }

    public Map<String, Integer> getActiveSlotsByChannel() {
        return this.activeSlotsByChannel;
    }

    public void setActiveSlotsByChannel(Map<String, Integer> activeSlotsByChannel) {
        this.activeSlotsByChannel = activeSlotsByChannel;
    }

    public UserData withActiveSlotsByChannel(Map<String, Integer> activeSlotsByChannel) {
        this.setActiveSlotsByChannel(activeSlotsByChannel);
        return this;
    }

    public UserData addActiveSlotsByChannelEntry(String key, Integer value) {
        if (null == this.activeSlotsByChannel) {
            this.activeSlotsByChannel = new HashMap<String, Integer>();
        }
        if (this.activeSlotsByChannel.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.activeSlotsByChannel.put(key, value);
        return this;
    }

    public UserData clearActiveSlotsByChannelEntries() {
        this.activeSlotsByChannel = null;
        return this;
    }

    public List<AgentContactReference> getContacts() {
        return this.contacts;
    }

    public void setContacts(Collection<AgentContactReference> contacts) {
        if (contacts == null) {
            this.contacts = null;
            return;
        }
        this.contacts = new ArrayList<AgentContactReference>(contacts);
    }

    public UserData withContacts(AgentContactReference ... contacts) {
        if (this.contacts == null) {
            this.setContacts(new ArrayList<AgentContactReference>(contacts.length));
        }
        for (AgentContactReference ele : contacts) {
            this.contacts.add(ele);
        }
        return this;
    }

    public UserData withContacts(Collection<AgentContactReference> contacts) {
        this.setContacts(contacts);
        return this;
    }

    public void setNextStatus(String nextStatus) {
        this.nextStatus = nextStatus;
    }

    public String getNextStatus() {
        return this.nextStatus;
    }

    public UserData withNextStatus(String nextStatus) {
        this.setNextStatus(nextStatus);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUser() != null) {
            sb.append("User: ").append(this.getUser()).append(",");
        }
        if (this.getRoutingProfile() != null) {
            sb.append("RoutingProfile: ").append(this.getRoutingProfile()).append(",");
        }
        if (this.getHierarchyPath() != null) {
            sb.append("HierarchyPath: ").append(this.getHierarchyPath()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAvailableSlotsByChannel() != null) {
            sb.append("AvailableSlotsByChannel: ").append(this.getAvailableSlotsByChannel()).append(",");
        }
        if (this.getMaxSlotsByChannel() != null) {
            sb.append("MaxSlotsByChannel: ").append(this.getMaxSlotsByChannel()).append(",");
        }
        if (this.getActiveSlotsByChannel() != null) {
            sb.append("ActiveSlotsByChannel: ").append(this.getActiveSlotsByChannel()).append(",");
        }
        if (this.getContacts() != null) {
            sb.append("Contacts: ").append(this.getContacts()).append(",");
        }
        if (this.getNextStatus() != null) {
            sb.append("NextStatus: ").append(this.getNextStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData)obj;
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        if (other.getUser() != null && !other.getUser().equals(this.getUser())) {
            return false;
        }
        if (other.getRoutingProfile() == null ^ this.getRoutingProfile() == null) {
            return false;
        }
        if (other.getRoutingProfile() != null && !other.getRoutingProfile().equals(this.getRoutingProfile())) {
            return false;
        }
        if (other.getHierarchyPath() == null ^ this.getHierarchyPath() == null) {
            return false;
        }
        if (other.getHierarchyPath() != null && !other.getHierarchyPath().equals(this.getHierarchyPath())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAvailableSlotsByChannel() == null ^ this.getAvailableSlotsByChannel() == null) {
            return false;
        }
        if (other.getAvailableSlotsByChannel() != null && !other.getAvailableSlotsByChannel().equals(this.getAvailableSlotsByChannel())) {
            return false;
        }
        if (other.getMaxSlotsByChannel() == null ^ this.getMaxSlotsByChannel() == null) {
            return false;
        }
        if (other.getMaxSlotsByChannel() != null && !other.getMaxSlotsByChannel().equals(this.getMaxSlotsByChannel())) {
            return false;
        }
        if (other.getActiveSlotsByChannel() == null ^ this.getActiveSlotsByChannel() == null) {
            return false;
        }
        if (other.getActiveSlotsByChannel() != null && !other.getActiveSlotsByChannel().equals(this.getActiveSlotsByChannel())) {
            return false;
        }
        if (other.getContacts() == null ^ this.getContacts() == null) {
            return false;
        }
        if (other.getContacts() != null && !other.getContacts().equals(this.getContacts())) {
            return false;
        }
        if (other.getNextStatus() == null ^ this.getNextStatus() == null) {
            return false;
        }
        return other.getNextStatus() == null || other.getNextStatus().equals(this.getNextStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingProfile() == null ? 0 : this.getRoutingProfile().hashCode());
        hashCode = 31 * hashCode + (this.getHierarchyPath() == null ? 0 : this.getHierarchyPath().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableSlotsByChannel() == null ? 0 : this.getAvailableSlotsByChannel().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSlotsByChannel() == null ? 0 : this.getMaxSlotsByChannel().hashCode());
        hashCode = 31 * hashCode + (this.getActiveSlotsByChannel() == null ? 0 : this.getActiveSlotsByChannel().hashCode());
        hashCode = 31 * hashCode + (this.getContacts() == null ? 0 : this.getContacts().hashCode());
        hashCode = 31 * hashCode + (this.getNextStatus() == null ? 0 : this.getNextStatus().hashCode());
        return hashCode;
    }

    public UserData clone() {
        try {
            return (UserData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

