/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.Condition;
import com.amazonaws.services.connect.model.TargetListType;
import com.amazonaws.services.connect.model.transform.ListConditionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCondition
implements Serializable,
Cloneable,
StructuredPojo {
    private String targetListType;
    private List<Condition> conditions;

    public void setTargetListType(String targetListType) {
        this.targetListType = targetListType;
    }

    public String getTargetListType() {
        return this.targetListType;
    }

    public ListCondition withTargetListType(String targetListType) {
        this.setTargetListType(targetListType);
        return this;
    }

    public ListCondition withTargetListType(TargetListType targetListType) {
        this.targetListType = targetListType.toString();
        return this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<Condition> conditions) {
        if (conditions == null) {
            this.conditions = null;
            return;
        }
        this.conditions = new ArrayList<Condition>(conditions);
    }

    public ListCondition withConditions(Condition ... conditions) {
        if (this.conditions == null) {
            this.setConditions(new ArrayList<Condition>(conditions.length));
        }
        for (Condition ele : conditions) {
            this.conditions.add(ele);
        }
        return this;
    }

    public ListCondition withConditions(Collection<Condition> conditions) {
        this.setConditions(conditions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetListType() != null) {
            sb.append("TargetListType: ").append(this.getTargetListType()).append(",");
        }
        if (this.getConditions() != null) {
            sb.append("Conditions: ").append(this.getConditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCondition)) {
            return false;
        }
        ListCondition other = (ListCondition)obj;
        if (other.getTargetListType() == null ^ this.getTargetListType() == null) {
            return false;
        }
        if (other.getTargetListType() != null && !other.getTargetListType().equals(this.getTargetListType())) {
            return false;
        }
        if (other.getConditions() == null ^ this.getConditions() == null) {
            return false;
        }
        return other.getConditions() == null || other.getConditions().equals(this.getConditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetListType() == null ? 0 : this.getTargetListType().hashCode());
        hashCode = 31 * hashCode + (this.getConditions() == null ? 0 : this.getConditions().hashCode());
        return hashCode;
    }

    public ListCondition clone() {
        try {
            return (ListCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ListConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

