/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connect.model.DeviceInfo;

@SdkInternalApi
public class DeviceInfoMarshaller {
    private static final MarshallingInfo<String> PLATFORMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformName").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").build();
    private static final MarshallingInfo<String> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").build();
    private static final DeviceInfoMarshaller instance = new DeviceInfoMarshaller();

    public static DeviceInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceInfo deviceInfo, ProtocolMarshaller protocolMarshaller) {
        if (deviceInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceInfo.getPlatformName(), PLATFORMNAME_BINDING);
            protocolMarshaller.marshall((Object)deviceInfo.getPlatformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)deviceInfo.getOperatingSystem(), OPERATINGSYSTEM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

