/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.StorageProfileSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStorageProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<StorageProfileSummary> storageProfiles;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStorageProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<StorageProfileSummary> getStorageProfiles() {
        return this.storageProfiles;
    }

    public void setStorageProfiles(Collection<StorageProfileSummary> storageProfiles) {
        if (storageProfiles == null) {
            this.storageProfiles = null;
            return;
        }
        this.storageProfiles = new ArrayList<StorageProfileSummary>(storageProfiles);
    }

    public ListStorageProfilesResult withStorageProfiles(StorageProfileSummary ... storageProfiles) {
        if (this.storageProfiles == null) {
            this.setStorageProfiles(new ArrayList<StorageProfileSummary>(storageProfiles.length));
        }
        for (StorageProfileSummary ele : storageProfiles) {
            this.storageProfiles.add(ele);
        }
        return this;
    }

    public ListStorageProfilesResult withStorageProfiles(Collection<StorageProfileSummary> storageProfiles) {
        this.setStorageProfiles(storageProfiles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getStorageProfiles() != null) {
            sb.append("StorageProfiles: ").append(this.getStorageProfiles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageProfilesResult)) {
            return false;
        }
        ListStorageProfilesResult other = (ListStorageProfilesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStorageProfiles() == null ^ this.getStorageProfiles() == null) {
            return false;
        }
        return other.getStorageProfiles() == null || other.getStorageProfiles().equals(this.getStorageProfiles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStorageProfiles() == null ? 0 : this.getStorageProfiles().hashCode());
        return hashCode;
    }

    public ListStorageProfilesResult clone() {
        try {
            return (ListStorageProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

