/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.StepParameter;
import com.amazonaws.services.deadline.model.transform.ParameterSpaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParameterSpace
implements Serializable,
Cloneable,
StructuredPojo {
    private String combination;
    private List<StepParameter> parameters;

    public void setCombination(String combination) {
        this.combination = combination;
    }

    public String getCombination() {
        return this.combination;
    }

    public ParameterSpace withCombination(String combination) {
        this.setCombination(combination);
        return this;
    }

    public List<StepParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<StepParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<StepParameter>(parameters);
    }

    public ParameterSpace withParameters(StepParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<StepParameter>(parameters.length));
        }
        for (StepParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ParameterSpace withParameters(Collection<StepParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCombination() != null) {
            sb.append("Combination: ").append(this.getCombination()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterSpace)) {
            return false;
        }
        ParameterSpace other = (ParameterSpace)obj;
        if (other.getCombination() == null ^ this.getCombination() == null) {
            return false;
        }
        if (other.getCombination() != null && !other.getCombination().equals(this.getCombination())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCombination() == null ? 0 : this.getCombination().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ParameterSpace clone() {
        try {
            return (ParameterSpace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterSpaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

