/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.TaskParameterValue;
import com.amazonaws.services.deadline.model.transform.TaskRunSessionActionDefinitionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TaskRunSessionActionDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, TaskParameterValue> parameters;
    private String stepId;
    private String taskId;

    public Map<String, TaskParameterValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, TaskParameterValue> parameters) {
        this.parameters = parameters;
    }

    public TaskRunSessionActionDefinition withParameters(Map<String, TaskParameterValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public TaskRunSessionActionDefinition addParametersEntry(String key, TaskParameterValue value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, TaskParameterValue>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public TaskRunSessionActionDefinition clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public String getStepId() {
        return this.stepId;
    }

    public TaskRunSessionActionDefinition withStepId(String stepId) {
        this.setStepId(stepId);
        return this;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskRunSessionActionDefinition withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStepId() != null) {
            sb.append("StepId: ").append(this.getStepId()).append(",");
        }
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunSessionActionDefinition)) {
            return false;
        }
        TaskRunSessionActionDefinition other = (TaskRunSessionActionDefinition)obj;
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getStepId() == null ^ this.getStepId() == null) {
            return false;
        }
        if (other.getStepId() != null && !other.getStepId().equals(this.getStepId())) {
            return false;
        }
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        return other.getTaskId() == null || other.getTaskId().equals(this.getTaskId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getStepId() == null ? 0 : this.getStepId().hashCode());
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        return hashCode;
    }

    public TaskRunSessionActionDefinition clone() {
        try {
            return (TaskRunSessionActionDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskRunSessionActionDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

