/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.UnassignIpv6AddressesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UnassignIpv6AddressesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<UnassignIpv6AddressesRequest> {
    private String networkInterfaceId;
    private SdkInternalList<String> ipv6Addresses;

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public UnassignIpv6AddressesRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    public List<String> getIpv6Addresses() {
        if (this.ipv6Addresses == null) {
            this.ipv6Addresses = new SdkInternalList();
        }
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<String> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new SdkInternalList(ipv6Addresses);
    }

    public UnassignIpv6AddressesRequest withIpv6Addresses(String ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses((Collection<String>)new SdkInternalList(ipv6Addresses.length));
        }
        for (String ele : ipv6Addresses) {
            this.ipv6Addresses.add((Object)ele);
        }
        return this;
    }

    public UnassignIpv6AddressesRequest withIpv6Addresses(Collection<String> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    @Override
    public Request<UnassignIpv6AddressesRequest> getDryRunRequest() {
        Request<UnassignIpv6AddressesRequest> request = new UnassignIpv6AddressesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.getNetworkInterfaceId()).append(",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.getIpv6Addresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesRequest)) {
            return false;
        }
        UnassignIpv6AddressesRequest other = (UnassignIpv6AddressesRequest)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        return other.getIpv6Addresses() == null || other.getIpv6Addresses().equals(this.getIpv6Addresses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        return hashCode;
    }

    public UnassignIpv6AddressesRequest clone() {
        return (UnassignIpv6AddressesRequest)super.clone();
    }
}

