/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ecr.model.DescribeImagesFilter;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeImagesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String registryId;
    private String repositoryName;
    private List<ImageIdentifier> imageIds;
    private String nextToken;
    private Integer maxResults;
    private DescribeImagesFilter filter;

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public DescribeImagesRequest withRegistryId(String registryId) {
        this.setRegistryId(registryId);
        return this;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public DescribeImagesRequest withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public List<ImageIdentifier> getImageIds() {
        return this.imageIds;
    }

    public void setImageIds(Collection<ImageIdentifier> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new ArrayList<ImageIdentifier>(imageIds);
    }

    public DescribeImagesRequest withImageIds(ImageIdentifier ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds(new ArrayList<ImageIdentifier>(imageIds.length));
        }
        for (ImageIdentifier ele : imageIds) {
            this.imageIds.add(ele);
        }
        return this;
    }

    public DescribeImagesRequest withImageIds(Collection<ImageIdentifier> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeImagesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeImagesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setFilter(DescribeImagesFilter filter) {
        this.filter = filter;
    }

    public DescribeImagesFilter getFilter() {
        return this.filter;
    }

    public DescribeImagesRequest withFilter(DescribeImagesFilter filter) {
        this.setFilter(filter);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegistryId() != null) {
            sb.append("RegistryId: ").append(this.getRegistryId()).append(",");
        }
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getImageIds() != null) {
            sb.append("ImageIds: ").append(this.getImageIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest)obj;
        if (other.getRegistryId() == null ^ this.getRegistryId() == null) {
            return false;
        }
        if (other.getRegistryId() != null && !other.getRegistryId().equals(this.getRegistryId())) {
            return false;
        }
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        return other.getFilter() == null || other.getFilter().equals(this.getFilter());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegistryId() == null ? 0 : this.getRegistryId().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        return hashCode;
    }

    public DescribeImagesRequest clone() {
        return (DescribeImagesRequest)super.clone();
    }
}

