/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.transform.CompatibilityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Compatibility
implements Serializable,
Cloneable,
StructuredPojo {
    private String clusterVersion;
    private List<String> platformVersions;
    private Boolean defaultVersion;

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public Compatibility withClusterVersion(String clusterVersion) {
        this.setClusterVersion(clusterVersion);
        return this;
    }

    public List<String> getPlatformVersions() {
        return this.platformVersions;
    }

    public void setPlatformVersions(Collection<String> platformVersions) {
        if (platformVersions == null) {
            this.platformVersions = null;
            return;
        }
        this.platformVersions = new ArrayList<String>(platformVersions);
    }

    public Compatibility withPlatformVersions(String ... platformVersions) {
        if (this.platformVersions == null) {
            this.setPlatformVersions(new ArrayList<String>(platformVersions.length));
        }
        for (String ele : platformVersions) {
            this.platformVersions.add(ele);
        }
        return this;
    }

    public Compatibility withPlatformVersions(Collection<String> platformVersions) {
        this.setPlatformVersions(platformVersions);
        return this;
    }

    public void setDefaultVersion(Boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public Boolean getDefaultVersion() {
        return this.defaultVersion;
    }

    public Compatibility withDefaultVersion(Boolean defaultVersion) {
        this.setDefaultVersion(defaultVersion);
        return this;
    }

    public Boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.getClusterVersion()).append(",");
        }
        if (this.getPlatformVersions() != null) {
            sb.append("PlatformVersions: ").append(this.getPlatformVersions()).append(",");
        }
        if (this.getDefaultVersion() != null) {
            sb.append("DefaultVersion: ").append(this.getDefaultVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compatibility)) {
            return false;
        }
        Compatibility other = (Compatibility)obj;
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getPlatformVersions() == null ^ this.getPlatformVersions() == null) {
            return false;
        }
        if (other.getPlatformVersions() != null && !other.getPlatformVersions().equals(this.getPlatformVersions())) {
            return false;
        }
        if (other.getDefaultVersion() == null ^ this.getDefaultVersion() == null) {
            return false;
        }
        return other.getDefaultVersion() == null || other.getDefaultVersion().equals(this.getDefaultVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersions() == null ? 0 : this.getPlatformVersions().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVersion() == null ? 0 : this.getDefaultVersion().hashCode());
        return hashCode;
    }

    public Compatibility clone() {
        try {
            return (Compatibility)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompatibilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

