/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListBlueprintsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<String> blueprints;
    private String nextToken;

    public List<String> getBlueprints() {
        return this.blueprints;
    }

    public void setBlueprints(Collection<String> blueprints) {
        if (blueprints == null) {
            this.blueprints = null;
            return;
        }
        this.blueprints = new ArrayList<String>(blueprints);
    }

    public ListBlueprintsResult withBlueprints(String ... blueprints) {
        if (this.blueprints == null) {
            this.setBlueprints(new ArrayList<String>(blueprints.length));
        }
        for (String ele : blueprints) {
            this.blueprints.add(ele);
        }
        return this;
    }

    public ListBlueprintsResult withBlueprints(Collection<String> blueprints) {
        this.setBlueprints(blueprints);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListBlueprintsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlueprints() != null) {
            sb.append("Blueprints: ").append(this.getBlueprints()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlueprintsResult)) {
            return false;
        }
        ListBlueprintsResult other = (ListBlueprintsResult)obj;
        if (other.getBlueprints() == null ^ this.getBlueprints() == null) {
            return false;
        }
        if (other.getBlueprints() != null && !other.getBlueprints().equals(this.getBlueprints())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlueprints() == null ? 0 : this.getBlueprints().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListBlueprintsResult clone() {
        try {
            return (ListBlueprintsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

