/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.ScanThreatName;
import com.amazonaws.services.guardduty.model.transform.ThreatDetectedByNameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThreatDetectedByName
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer itemCount;
    private Integer uniqueThreatNameCount;
    private Boolean shortened;
    private List<ScanThreatName> threatNames;

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public Integer getItemCount() {
        return this.itemCount;
    }

    public ThreatDetectedByName withItemCount(Integer itemCount) {
        this.setItemCount(itemCount);
        return this;
    }

    public void setUniqueThreatNameCount(Integer uniqueThreatNameCount) {
        this.uniqueThreatNameCount = uniqueThreatNameCount;
    }

    public Integer getUniqueThreatNameCount() {
        return this.uniqueThreatNameCount;
    }

    public ThreatDetectedByName withUniqueThreatNameCount(Integer uniqueThreatNameCount) {
        this.setUniqueThreatNameCount(uniqueThreatNameCount);
        return this;
    }

    public void setShortened(Boolean shortened) {
        this.shortened = shortened;
    }

    public Boolean getShortened() {
        return this.shortened;
    }

    public ThreatDetectedByName withShortened(Boolean shortened) {
        this.setShortened(shortened);
        return this;
    }

    public Boolean isShortened() {
        return this.shortened;
    }

    public List<ScanThreatName> getThreatNames() {
        return this.threatNames;
    }

    public void setThreatNames(Collection<ScanThreatName> threatNames) {
        if (threatNames == null) {
            this.threatNames = null;
            return;
        }
        this.threatNames = new ArrayList<ScanThreatName>(threatNames);
    }

    public ThreatDetectedByName withThreatNames(ScanThreatName ... threatNames) {
        if (this.threatNames == null) {
            this.setThreatNames(new ArrayList<ScanThreatName>(threatNames.length));
        }
        for (ScanThreatName ele : threatNames) {
            this.threatNames.add(ele);
        }
        return this;
    }

    public ThreatDetectedByName withThreatNames(Collection<ScanThreatName> threatNames) {
        this.setThreatNames(threatNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemCount() != null) {
            sb.append("ItemCount: ").append(this.getItemCount()).append(",");
        }
        if (this.getUniqueThreatNameCount() != null) {
            sb.append("UniqueThreatNameCount: ").append(this.getUniqueThreatNameCount()).append(",");
        }
        if (this.getShortened() != null) {
            sb.append("Shortened: ").append(this.getShortened()).append(",");
        }
        if (this.getThreatNames() != null) {
            sb.append("ThreatNames: ").append(this.getThreatNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatDetectedByName)) {
            return false;
        }
        ThreatDetectedByName other = (ThreatDetectedByName)obj;
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getUniqueThreatNameCount() == null ^ this.getUniqueThreatNameCount() == null) {
            return false;
        }
        if (other.getUniqueThreatNameCount() != null && !other.getUniqueThreatNameCount().equals(this.getUniqueThreatNameCount())) {
            return false;
        }
        if (other.getShortened() == null ^ this.getShortened() == null) {
            return false;
        }
        if (other.getShortened() != null && !other.getShortened().equals(this.getShortened())) {
            return false;
        }
        if (other.getThreatNames() == null ^ this.getThreatNames() == null) {
            return false;
        }
        return other.getThreatNames() == null || other.getThreatNames().equals(this.getThreatNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getUniqueThreatNameCount() == null ? 0 : this.getUniqueThreatNameCount().hashCode());
        hashCode = 31 * hashCode + (this.getShortened() == null ? 0 : this.getShortened().hashCode());
        hashCode = 31 * hashCode + (this.getThreatNames() == null ? 0 : this.getThreatNames().hashCode());
        return hashCode;
    }

    public ThreatDetectedByName clone() {
        try {
            return (ThreatDetectedByName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThreatDetectedByNameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

