/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.identitymanagement.model;

import java.io.Serializable;

/**
 * <p>
 * Contains information about an IAM group, including all of the group's
 * policies.
 * </p>
 * <p>
 * This data type is used as a response element in the
 * GetAccountAuthorizationDetails action.
 * </p>
 */
public class GroupDetail implements Serializable, Cloneable {

    /**
     * The path to the group. For more information about paths, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 512<br/>
     * <b>Pattern: </b>(&#92;u002F)|(&#92;u002F[&#92;u0021-&#92;u007F]+&#92;u002F)<br/>
     */
    private String path;

    /**
     * The friendly name that identifies the group.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w+=,.@-]*<br/>
     */
    private String groupName;

    /**
     * The stable and unique string identifying the group. For more
     * information about IDs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>16 - 32<br/>
     * <b>Pattern: </b>[\w]*<br/>
     */
    private String groupId;

    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     * resources. <p>For more information about ARNs, go to <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     * General Reference</i>.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>20 - 2048<br/>
     */
    private String arn;

    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     * 8601 date-time format</a>, when the group was created.
     */
    private java.util.Date createDate;

    /**
     * A list of the inline policies embedded in the group.
     */
    private com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail> groupPolicyList;

    /**
     * A list of the managed policies attached to the group.
     */
    private com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy> attachedManagedPolicies;

    /**
     * The path to the group. For more information about paths, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 512<br/>
     * <b>Pattern: </b>(&#92;u002F)|(&#92;u002F[&#92;u0021-&#92;u007F]+&#92;u002F)<br/>
     *
     * @return The path to the group. For more information about paths, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     */
    public String getPath() {
        return path;
    }
    
    /**
     * The path to the group. For more information about paths, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 512<br/>
     * <b>Pattern: </b>(&#92;u002F)|(&#92;u002F[&#92;u0021-&#92;u007F]+&#92;u002F)<br/>
     *
     * @param path The path to the group. For more information about paths, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     */
    public void setPath(String path) {
        this.path = path;
    }
    
    /**
     * The path to the group. For more information about paths, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 512<br/>
     * <b>Pattern: </b>(&#92;u002F)|(&#92;u002F[&#92;u0021-&#92;u007F]+&#92;u002F)<br/>
     *
     * @param path The path to the group. For more information about paths, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * The friendly name that identifies the group.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w+=,.@-]*<br/>
     *
     * @return The friendly name that identifies the group.
     */
    public String getGroupName() {
        return groupName;
    }
    
    /**
     * The friendly name that identifies the group.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w+=,.@-]*<br/>
     *
     * @param groupName The friendly name that identifies the group.
     */
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
    
    /**
     * The friendly name that identifies the group.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 128<br/>
     * <b>Pattern: </b>[\w+=,.@-]*<br/>
     *
     * @param groupName The friendly name that identifies the group.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
     * The stable and unique string identifying the group. For more
     * information about IDs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>16 - 32<br/>
     * <b>Pattern: </b>[\w]*<br/>
     *
     * @return The stable and unique string identifying the group. For more
     *         information about IDs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     */
    public String getGroupId() {
        return groupId;
    }
    
    /**
     * The stable and unique string identifying the group. For more
     * information about IDs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>16 - 32<br/>
     * <b>Pattern: </b>[\w]*<br/>
     *
     * @param groupId The stable and unique string identifying the group. For more
     *         information about IDs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     */
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
    
    /**
     * The stable and unique string identifying the group. For more
     * information about IDs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * Identifiers</a> in the <i>Using IAM</i> guide.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>16 - 32<br/>
     * <b>Pattern: </b>[\w]*<br/>
     *
     * @param groupId The stable and unique string identifying the group. For more
     *         information about IDs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         Identifiers</a> in the <i>Using IAM</i> guide.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     * resources. <p>For more information about ARNs, go to <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     * General Reference</i>.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>20 - 2048<br/>
     *
     * @return The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     *         resources. <p>For more information about ARNs, go to <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     *         General Reference</i>.
     */
    public String getArn() {
        return arn;
    }
    
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     * resources. <p>For more information about ARNs, go to <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     * General Reference</i>.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>20 - 2048<br/>
     *
     * @param arn The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     *         resources. <p>For more information about ARNs, go to <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     *         General Reference</i>.
     */
    public void setArn(String arn) {
        this.arn = arn;
    }
    
    /**
     * The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     * resources. <p>For more information about ARNs, go to <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     * General Reference</i>.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>20 - 2048<br/>
     *
     * @param arn The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS
     *         resources. <p>For more information about ARNs, go to <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS
     *         General Reference</i>.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withArn(String arn) {
        this.arn = arn;
        return this;
    }

    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     * 8601 date-time format</a>, when the group was created.
     *
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     *         8601 date-time format</a>, when the group was created.
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }
    
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     * 8601 date-time format</a>, when the group was created.
     *
     * @param createDate The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     *         8601 date-time format</a>, when the group was created.
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    
    /**
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     * 8601 date-time format</a>, when the group was created.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param createDate The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO
     *         8601 date-time format</a>, when the group was created.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
        return this;
    }

    /**
     * A list of the inline policies embedded in the group.
     *
     * @return A list of the inline policies embedded in the group.
     */
    public java.util.List<PolicyDetail> getGroupPolicyList() {
        if (groupPolicyList == null) {
              groupPolicyList = new com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail>();
              groupPolicyList.setAutoConstruct(true);
        }
        return groupPolicyList;
    }
    
    /**
     * A list of the inline policies embedded in the group.
     *
     * @param groupPolicyList A list of the inline policies embedded in the group.
     */
    public void setGroupPolicyList(java.util.Collection<PolicyDetail> groupPolicyList) {
        if (groupPolicyList == null) {
            this.groupPolicyList = null;
            return;
        }
        com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail> groupPolicyListCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail>(groupPolicyList.size());
        groupPolicyListCopy.addAll(groupPolicyList);
        this.groupPolicyList = groupPolicyListCopy;
    }
    
    /**
     * A list of the inline policies embedded in the group.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param groupPolicyList A list of the inline policies embedded in the group.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withGroupPolicyList(PolicyDetail... groupPolicyList) {
        if (getGroupPolicyList() == null) setGroupPolicyList(new java.util.ArrayList<PolicyDetail>(groupPolicyList.length));
        for (PolicyDetail value : groupPolicyList) {
            getGroupPolicyList().add(value);
        }
        return this;
    }
    
    /**
     * A list of the inline policies embedded in the group.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param groupPolicyList A list of the inline policies embedded in the group.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withGroupPolicyList(java.util.Collection<PolicyDetail> groupPolicyList) {
        if (groupPolicyList == null) {
            this.groupPolicyList = null;
        } else {
            com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail> groupPolicyListCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<PolicyDetail>(groupPolicyList.size());
            groupPolicyListCopy.addAll(groupPolicyList);
            this.groupPolicyList = groupPolicyListCopy;
        }

        return this;
    }

    /**
     * A list of the managed policies attached to the group.
     *
     * @return A list of the managed policies attached to the group.
     */
    public java.util.List<AttachedPolicy> getAttachedManagedPolicies() {
        if (attachedManagedPolicies == null) {
              attachedManagedPolicies = new com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy>();
              attachedManagedPolicies.setAutoConstruct(true);
        }
        return attachedManagedPolicies;
    }
    
    /**
     * A list of the managed policies attached to the group.
     *
     * @param attachedManagedPolicies A list of the managed policies attached to the group.
     */
    public void setAttachedManagedPolicies(java.util.Collection<AttachedPolicy> attachedManagedPolicies) {
        if (attachedManagedPolicies == null) {
            this.attachedManagedPolicies = null;
            return;
        }
        com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy> attachedManagedPoliciesCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy>(attachedManagedPolicies.size());
        attachedManagedPoliciesCopy.addAll(attachedManagedPolicies);
        this.attachedManagedPolicies = attachedManagedPoliciesCopy;
    }
    
    /**
     * A list of the managed policies attached to the group.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param attachedManagedPolicies A list of the managed policies attached to the group.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withAttachedManagedPolicies(AttachedPolicy... attachedManagedPolicies) {
        if (getAttachedManagedPolicies() == null) setAttachedManagedPolicies(new java.util.ArrayList<AttachedPolicy>(attachedManagedPolicies.length));
        for (AttachedPolicy value : attachedManagedPolicies) {
            getAttachedManagedPolicies().add(value);
        }
        return this;
    }
    
    /**
     * A list of the managed policies attached to the group.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param attachedManagedPolicies A list of the managed policies attached to the group.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public GroupDetail withAttachedManagedPolicies(java.util.Collection<AttachedPolicy> attachedManagedPolicies) {
        if (attachedManagedPolicies == null) {
            this.attachedManagedPolicies = null;
        } else {
            com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy> attachedManagedPoliciesCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<AttachedPolicy>(attachedManagedPolicies.size());
            attachedManagedPoliciesCopy.addAll(attachedManagedPolicies);
            this.attachedManagedPolicies = attachedManagedPoliciesCopy;
        }

        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPath() != null) sb.append("Path: " + getPath() + ",");
        if (getGroupName() != null) sb.append("GroupName: " + getGroupName() + ",");
        if (getGroupId() != null) sb.append("GroupId: " + getGroupId() + ",");
        if (getArn() != null) sb.append("Arn: " + getArn() + ",");
        if (getCreateDate() != null) sb.append("CreateDate: " + getCreateDate() + ",");
        if (getGroupPolicyList() != null) sb.append("GroupPolicyList: " + getGroupPolicyList() + ",");
        if (getAttachedManagedPolicies() != null) sb.append("AttachedManagedPolicies: " + getAttachedManagedPolicies() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getPath() == null) ? 0 : getPath().hashCode()); 
        hashCode = prime * hashCode + ((getGroupName() == null) ? 0 : getGroupName().hashCode()); 
        hashCode = prime * hashCode + ((getGroupId() == null) ? 0 : getGroupId().hashCode()); 
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode()); 
        hashCode = prime * hashCode + ((getCreateDate() == null) ? 0 : getCreateDate().hashCode()); 
        hashCode = prime * hashCode + ((getGroupPolicyList() == null) ? 0 : getGroupPolicyList().hashCode()); 
        hashCode = prime * hashCode + ((getAttachedManagedPolicies() == null) ? 0 : getAttachedManagedPolicies().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof GroupDetail == false) return false;
        GroupDetail other = (GroupDetail)obj;
        
        if (other.getPath() == null ^ this.getPath() == null) return false;
        if (other.getPath() != null && other.getPath().equals(this.getPath()) == false) return false; 
        if (other.getGroupName() == null ^ this.getGroupName() == null) return false;
        if (other.getGroupName() != null && other.getGroupName().equals(this.getGroupName()) == false) return false; 
        if (other.getGroupId() == null ^ this.getGroupId() == null) return false;
        if (other.getGroupId() != null && other.getGroupId().equals(this.getGroupId()) == false) return false; 
        if (other.getArn() == null ^ this.getArn() == null) return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false) return false; 
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) return false;
        if (other.getCreateDate() != null && other.getCreateDate().equals(this.getCreateDate()) == false) return false; 
        if (other.getGroupPolicyList() == null ^ this.getGroupPolicyList() == null) return false;
        if (other.getGroupPolicyList() != null && other.getGroupPolicyList().equals(this.getGroupPolicyList()) == false) return false; 
        if (other.getAttachedManagedPolicies() == null ^ this.getAttachedManagedPolicies() == null) return false;
        if (other.getAttachedManagedPolicies() != null && other.getAttachedManagedPolicies().equals(this.getAttachedManagedPolicies()) == false) return false; 
        return true;
    }
    
    @Override
    public GroupDetail clone() {
        try {
            return (GroupDetail) super.clone();
        
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                    + "even though we're Cloneable!",
                    e);
        }
        
    }

}
    