/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.PackageSortBy;
import com.amazonaws.services.inspector2.model.SortOrder;
import com.amazonaws.services.inspector2.model.StringFilter;
import com.amazonaws.services.inspector2.model.transform.PackageAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PackageAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<StringFilter> packageNames;
    private String sortBy;
    private String sortOrder;

    public List<StringFilter> getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(Collection<StringFilter> packageNames) {
        if (packageNames == null) {
            this.packageNames = null;
            return;
        }
        this.packageNames = new ArrayList<StringFilter>(packageNames);
    }

    public PackageAggregation withPackageNames(StringFilter ... packageNames) {
        if (this.packageNames == null) {
            this.setPackageNames(new ArrayList<StringFilter>(packageNames.length));
        }
        for (StringFilter ele : packageNames) {
            this.packageNames.add(ele);
        }
        return this;
    }

    public PackageAggregation withPackageNames(Collection<StringFilter> packageNames) {
        this.setPackageNames(packageNames);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public PackageAggregation withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public PackageAggregation withSortBy(PackageSortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public PackageAggregation withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public PackageAggregation withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageNames() != null) {
            sb.append("PackageNames: ").append(this.getPackageNames()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageAggregation)) {
            return false;
        }
        PackageAggregation other = (PackageAggregation)obj;
        if (other.getPackageNames() == null ^ this.getPackageNames() == null) {
            return false;
        }
        if (other.getPackageNames() != null && !other.getPackageNames().equals(this.getPackageNames())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageNames() == null ? 0 : this.getPackageNames().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    public PackageAggregation clone() {
        try {
            return (PackageAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

