/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.AuditFrequency;
import com.amazonaws.services.iot.model.DayOfWeek;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeScheduledAuditResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String frequency;
    private String dayOfMonth;
    private String dayOfWeek;
    private List<String> targetCheckNames;
    private String scheduledAuditName;
    private String scheduledAuditArn;

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public DescribeScheduledAuditResult withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public DescribeScheduledAuditResult withFrequency(AuditFrequency frequency) {
        this.frequency = frequency.toString();
        return this;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public DescribeScheduledAuditResult withDayOfMonth(String dayOfMonth) {
        this.setDayOfMonth(dayOfMonth);
        return this;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public DescribeScheduledAuditResult withDayOfWeek(String dayOfWeek) {
        this.setDayOfWeek(dayOfWeek);
        return this;
    }

    public DescribeScheduledAuditResult withDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek.toString();
        return this;
    }

    public List<String> getTargetCheckNames() {
        return this.targetCheckNames;
    }

    public void setTargetCheckNames(Collection<String> targetCheckNames) {
        if (targetCheckNames == null) {
            this.targetCheckNames = null;
            return;
        }
        this.targetCheckNames = new ArrayList<String>(targetCheckNames);
    }

    public DescribeScheduledAuditResult withTargetCheckNames(String ... targetCheckNames) {
        if (this.targetCheckNames == null) {
            this.setTargetCheckNames(new ArrayList<String>(targetCheckNames.length));
        }
        for (String ele : targetCheckNames) {
            this.targetCheckNames.add(ele);
        }
        return this;
    }

    public DescribeScheduledAuditResult withTargetCheckNames(Collection<String> targetCheckNames) {
        this.setTargetCheckNames(targetCheckNames);
        return this;
    }

    public void setScheduledAuditName(String scheduledAuditName) {
        this.scheduledAuditName = scheduledAuditName;
    }

    public String getScheduledAuditName() {
        return this.scheduledAuditName;
    }

    public DescribeScheduledAuditResult withScheduledAuditName(String scheduledAuditName) {
        this.setScheduledAuditName(scheduledAuditName);
        return this;
    }

    public void setScheduledAuditArn(String scheduledAuditArn) {
        this.scheduledAuditArn = scheduledAuditArn;
    }

    public String getScheduledAuditArn() {
        return this.scheduledAuditArn;
    }

    public DescribeScheduledAuditResult withScheduledAuditArn(String scheduledAuditArn) {
        this.setScheduledAuditArn(scheduledAuditArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency()).append(",");
        }
        if (this.getDayOfMonth() != null) {
            sb.append("DayOfMonth: ").append(this.getDayOfMonth()).append(",");
        }
        if (this.getDayOfWeek() != null) {
            sb.append("DayOfWeek: ").append(this.getDayOfWeek()).append(",");
        }
        if (this.getTargetCheckNames() != null) {
            sb.append("TargetCheckNames: ").append(this.getTargetCheckNames()).append(",");
        }
        if (this.getScheduledAuditName() != null) {
            sb.append("ScheduledAuditName: ").append(this.getScheduledAuditName()).append(",");
        }
        if (this.getScheduledAuditArn() != null) {
            sb.append("ScheduledAuditArn: ").append(this.getScheduledAuditArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledAuditResult)) {
            return false;
        }
        DescribeScheduledAuditResult other = (DescribeScheduledAuditResult)obj;
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getDayOfMonth() == null ^ this.getDayOfMonth() == null) {
            return false;
        }
        if (other.getDayOfMonth() != null && !other.getDayOfMonth().equals(this.getDayOfMonth())) {
            return false;
        }
        if (other.getDayOfWeek() == null ^ this.getDayOfWeek() == null) {
            return false;
        }
        if (other.getDayOfWeek() != null && !other.getDayOfWeek().equals(this.getDayOfWeek())) {
            return false;
        }
        if (other.getTargetCheckNames() == null ^ this.getTargetCheckNames() == null) {
            return false;
        }
        if (other.getTargetCheckNames() != null && !other.getTargetCheckNames().equals(this.getTargetCheckNames())) {
            return false;
        }
        if (other.getScheduledAuditName() == null ^ this.getScheduledAuditName() == null) {
            return false;
        }
        if (other.getScheduledAuditName() != null && !other.getScheduledAuditName().equals(this.getScheduledAuditName())) {
            return false;
        }
        if (other.getScheduledAuditArn() == null ^ this.getScheduledAuditArn() == null) {
            return false;
        }
        return other.getScheduledAuditArn() == null || other.getScheduledAuditArn().equals(this.getScheduledAuditArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getDayOfMonth() == null ? 0 : this.getDayOfMonth().hashCode());
        hashCode = 31 * hashCode + (this.getDayOfWeek() == null ? 0 : this.getDayOfWeek().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCheckNames() == null ? 0 : this.getTargetCheckNames().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledAuditName() == null ? 0 : this.getScheduledAuditName().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledAuditArn() == null ? 0 : this.getScheduledAuditArn().hashCode());
        return hashCode;
    }

    public DescribeScheduledAuditResult clone() {
        try {
            return (DescribeScheduledAuditResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

