/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.TransferData;
import java.util.Date;

@SdkInternalApi
public class TransferDataMarshaller {
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").build();
    private static final MarshallingInfo<String> REJECTREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectReason").build();
    private static final MarshallingInfo<Date> TRANSFERDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ACCEPTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("acceptDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> REJECTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rejectDate").timestampFormat("unixTimestamp").build();
    private static final TransferDataMarshaller instance = new TransferDataMarshaller();

    public static TransferDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransferData transferData, ProtocolMarshaller protocolMarshaller) {
        if (transferData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transferData.getTransferMessage(), TRANSFERMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)transferData.getRejectReason(), REJECTREASON_BINDING);
            protocolMarshaller.marshall((Object)transferData.getTransferDate(), TRANSFERDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.getAcceptDate(), ACCEPTDATE_BINDING);
            protocolMarshaller.marshall((Object)transferData.getRejectDate(), REJECTDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

