/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.Channel;
import com.amazonaws.services.ivs.model.IngestConfiguration;
import com.amazonaws.services.ivs.model.RecordingConfiguration;
import com.amazonaws.services.ivs.model.StreamEvent;
import com.amazonaws.services.ivs.model.transform.StreamSessionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StreamSession
implements Serializable,
Cloneable,
StructuredPojo {
    private String streamId;
    private Date startTime;
    private Date endTime;
    private Channel channel;
    private IngestConfiguration ingestConfiguration;
    private RecordingConfiguration recordingConfiguration;
    private List<StreamEvent> truncatedEvents;

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public StreamSession withStreamId(String streamId) {
        this.setStreamId(streamId);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public StreamSession withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public StreamSession withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public StreamSession withChannel(Channel channel) {
        this.setChannel(channel);
        return this;
    }

    public void setIngestConfiguration(IngestConfiguration ingestConfiguration) {
        this.ingestConfiguration = ingestConfiguration;
    }

    public IngestConfiguration getIngestConfiguration() {
        return this.ingestConfiguration;
    }

    public StreamSession withIngestConfiguration(IngestConfiguration ingestConfiguration) {
        this.setIngestConfiguration(ingestConfiguration);
        return this;
    }

    public void setRecordingConfiguration(RecordingConfiguration recordingConfiguration) {
        this.recordingConfiguration = recordingConfiguration;
    }

    public RecordingConfiguration getRecordingConfiguration() {
        return this.recordingConfiguration;
    }

    public StreamSession withRecordingConfiguration(RecordingConfiguration recordingConfiguration) {
        this.setRecordingConfiguration(recordingConfiguration);
        return this;
    }

    public List<StreamEvent> getTruncatedEvents() {
        return this.truncatedEvents;
    }

    public void setTruncatedEvents(Collection<StreamEvent> truncatedEvents) {
        if (truncatedEvents == null) {
            this.truncatedEvents = null;
            return;
        }
        this.truncatedEvents = new ArrayList<StreamEvent>(truncatedEvents);
    }

    public StreamSession withTruncatedEvents(StreamEvent ... truncatedEvents) {
        if (this.truncatedEvents == null) {
            this.setTruncatedEvents(new ArrayList<StreamEvent>(truncatedEvents.length));
        }
        for (StreamEvent ele : truncatedEvents) {
            this.truncatedEvents.add(ele);
        }
        return this;
    }

    public StreamSession withTruncatedEvents(Collection<StreamEvent> truncatedEvents) {
        this.setTruncatedEvents(truncatedEvents);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamId() != null) {
            sb.append("StreamId: ").append(this.getStreamId()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getChannel() != null) {
            sb.append("Channel: ").append(this.getChannel()).append(",");
        }
        if (this.getIngestConfiguration() != null) {
            sb.append("IngestConfiguration: ").append(this.getIngestConfiguration()).append(",");
        }
        if (this.getRecordingConfiguration() != null) {
            sb.append("RecordingConfiguration: ").append(this.getRecordingConfiguration()).append(",");
        }
        if (this.getTruncatedEvents() != null) {
            sb.append("TruncatedEvents: ").append(this.getTruncatedEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSession)) {
            return false;
        }
        StreamSession other = (StreamSession)obj;
        if (other.getStreamId() == null ^ this.getStreamId() == null) {
            return false;
        }
        if (other.getStreamId() != null && !other.getStreamId().equals(this.getStreamId())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getChannel() == null ^ this.getChannel() == null) {
            return false;
        }
        if (other.getChannel() != null && !other.getChannel().equals(this.getChannel())) {
            return false;
        }
        if (other.getIngestConfiguration() == null ^ this.getIngestConfiguration() == null) {
            return false;
        }
        if (other.getIngestConfiguration() != null && !other.getIngestConfiguration().equals(this.getIngestConfiguration())) {
            return false;
        }
        if (other.getRecordingConfiguration() == null ^ this.getRecordingConfiguration() == null) {
            return false;
        }
        if (other.getRecordingConfiguration() != null && !other.getRecordingConfiguration().equals(this.getRecordingConfiguration())) {
            return false;
        }
        if (other.getTruncatedEvents() == null ^ this.getTruncatedEvents() == null) {
            return false;
        }
        return other.getTruncatedEvents() == null || other.getTruncatedEvents().equals(this.getTruncatedEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamId() == null ? 0 : this.getStreamId().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getChannel() == null ? 0 : this.getChannel().hashCode());
        hashCode = 31 * hashCode + (this.getIngestConfiguration() == null ? 0 : this.getIngestConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRecordingConfiguration() == null ? 0 : this.getRecordingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTruncatedEvents() == null ? 0 : this.getTruncatedEvents().hashCode());
        return hashCode;
    }

    public StreamSession clone() {
        try {
            return (StreamSession)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

