/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.RecordingMode;
import com.amazonaws.services.ivs.model.ThumbnailConfigurationResolution;
import com.amazonaws.services.ivs.model.ThumbnailConfigurationStorage;
import com.amazonaws.services.ivs.model.transform.ThumbnailConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThumbnailConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String recordingMode;
    private Long targetIntervalSeconds;
    private String resolution;
    private List<String> storage;

    public void setRecordingMode(String recordingMode) {
        this.recordingMode = recordingMode;
    }

    public String getRecordingMode() {
        return this.recordingMode;
    }

    public ThumbnailConfiguration withRecordingMode(String recordingMode) {
        this.setRecordingMode(recordingMode);
        return this;
    }

    public ThumbnailConfiguration withRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode.toString();
        return this;
    }

    public void setTargetIntervalSeconds(Long targetIntervalSeconds) {
        this.targetIntervalSeconds = targetIntervalSeconds;
    }

    public Long getTargetIntervalSeconds() {
        return this.targetIntervalSeconds;
    }

    public ThumbnailConfiguration withTargetIntervalSeconds(Long targetIntervalSeconds) {
        this.setTargetIntervalSeconds(targetIntervalSeconds);
        return this;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getResolution() {
        return this.resolution;
    }

    public ThumbnailConfiguration withResolution(String resolution) {
        this.setResolution(resolution);
        return this;
    }

    public ThumbnailConfiguration withResolution(ThumbnailConfigurationResolution resolution) {
        this.resolution = resolution.toString();
        return this;
    }

    public List<String> getStorage() {
        return this.storage;
    }

    public void setStorage(Collection<String> storage) {
        if (storage == null) {
            this.storage = null;
            return;
        }
        this.storage = new ArrayList<String>(storage);
    }

    public ThumbnailConfiguration withStorage(String ... storage) {
        if (this.storage == null) {
            this.setStorage(new ArrayList<String>(storage.length));
        }
        for (String ele : storage) {
            this.storage.add(ele);
        }
        return this;
    }

    public ThumbnailConfiguration withStorage(Collection<String> storage) {
        this.setStorage(storage);
        return this;
    }

    public ThumbnailConfiguration withStorage(ThumbnailConfigurationStorage ... storage) {
        ArrayList<String> storageCopy = new ArrayList<String>(storage.length);
        for (ThumbnailConfigurationStorage value : storage) {
            storageCopy.add(value.toString());
        }
        if (this.getStorage() == null) {
            this.setStorage(storageCopy);
        } else {
            this.getStorage().addAll(storageCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecordingMode() != null) {
            sb.append("RecordingMode: ").append(this.getRecordingMode()).append(",");
        }
        if (this.getTargetIntervalSeconds() != null) {
            sb.append("TargetIntervalSeconds: ").append(this.getTargetIntervalSeconds()).append(",");
        }
        if (this.getResolution() != null) {
            sb.append("Resolution: ").append(this.getResolution()).append(",");
        }
        if (this.getStorage() != null) {
            sb.append("Storage: ").append(this.getStorage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailConfiguration)) {
            return false;
        }
        ThumbnailConfiguration other = (ThumbnailConfiguration)obj;
        if (other.getRecordingMode() == null ^ this.getRecordingMode() == null) {
            return false;
        }
        if (other.getRecordingMode() != null && !other.getRecordingMode().equals(this.getRecordingMode())) {
            return false;
        }
        if (other.getTargetIntervalSeconds() == null ^ this.getTargetIntervalSeconds() == null) {
            return false;
        }
        if (other.getTargetIntervalSeconds() != null && !other.getTargetIntervalSeconds().equals(this.getTargetIntervalSeconds())) {
            return false;
        }
        if (other.getResolution() == null ^ this.getResolution() == null) {
            return false;
        }
        if (other.getResolution() != null && !other.getResolution().equals(this.getResolution())) {
            return false;
        }
        if (other.getStorage() == null ^ this.getStorage() == null) {
            return false;
        }
        return other.getStorage() == null || other.getStorage().equals(this.getStorage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecordingMode() == null ? 0 : this.getRecordingMode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetIntervalSeconds() == null ? 0 : this.getTargetIntervalSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getResolution() == null ? 0 : this.getResolution().hashCode());
        hashCode = 31 * hashCode + (this.getStorage() == null ? 0 : this.getStorage().hashCode());
        return hashCode;
    }

    public ThumbnailConfiguration clone() {
        try {
            return (ThumbnailConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThumbnailConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

