/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.SharePointVersion;
import com.amazonaws.services.kendra.model.transform.SharePointConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SharePointConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String sharePointVersion;
    private List<String> urls;
    private String secretArn;
    private Boolean crawlAttachments;
    private DataSourceVpcConfiguration vpcConfiguration;
    private List<DataSourceToIndexFieldMapping> fieldMappings;

    public void setSharePointVersion(String sharePointVersion) {
        this.sharePointVersion = sharePointVersion;
    }

    public String getSharePointVersion() {
        return this.sharePointVersion;
    }

    public SharePointConfiguration withSharePointVersion(String sharePointVersion) {
        this.setSharePointVersion(sharePointVersion);
        return this;
    }

    public SharePointConfiguration withSharePointVersion(SharePointVersion sharePointVersion) {
        this.sharePointVersion = sharePointVersion.toString();
        return this;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(Collection<String> urls) {
        if (urls == null) {
            this.urls = null;
            return;
        }
        this.urls = new ArrayList<String>(urls);
    }

    public SharePointConfiguration withUrls(String ... urls) {
        if (this.urls == null) {
            this.setUrls(new ArrayList<String>(urls.length));
        }
        for (String ele : urls) {
            this.urls.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withUrls(Collection<String> urls) {
        this.setUrls(urls);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public SharePointConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setCrawlAttachments(Boolean crawlAttachments) {
        this.crawlAttachments = crawlAttachments;
    }

    public Boolean getCrawlAttachments() {
        return this.crawlAttachments;
    }

    public SharePointConfiguration withCrawlAttachments(Boolean crawlAttachments) {
        this.setCrawlAttachments(crawlAttachments);
        return this;
    }

    public Boolean isCrawlAttachments() {
        return this.crawlAttachments;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public SharePointConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public SharePointConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public SharePointConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSharePointVersion() != null) {
            sb.append("SharePointVersion: ").append(this.getSharePointVersion()).append(",");
        }
        if (this.getUrls() != null) {
            sb.append("Urls: ").append(this.getUrls()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getCrawlAttachments() != null) {
            sb.append("CrawlAttachments: ").append(this.getCrawlAttachments()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointConfiguration)) {
            return false;
        }
        SharePointConfiguration other = (SharePointConfiguration)obj;
        if (other.getSharePointVersion() == null ^ this.getSharePointVersion() == null) {
            return false;
        }
        if (other.getSharePointVersion() != null && !other.getSharePointVersion().equals(this.getSharePointVersion())) {
            return false;
        }
        if (other.getUrls() == null ^ this.getUrls() == null) {
            return false;
        }
        if (other.getUrls() != null && !other.getUrls().equals(this.getUrls())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getCrawlAttachments() == null ^ this.getCrawlAttachments() == null) {
            return false;
        }
        if (other.getCrawlAttachments() != null && !other.getCrawlAttachments().equals(this.getCrawlAttachments())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        return other.getFieldMappings() == null || other.getFieldMappings().equals(this.getFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSharePointVersion() == null ? 0 : this.getSharePointVersion().hashCode());
        hashCode = 31 * hashCode + (this.getUrls() == null ? 0 : this.getUrls().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlAttachments() == null ? 0 : this.getCrawlAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        return hashCode;
    }

    public SharePointConfiguration clone() {
        try {
            return (SharePointConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SharePointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

