/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SharePointConfiguration;
import java.util.List;

@SdkInternalApi
public class SharePointConfigurationMarshaller {
    private static final MarshallingInfo<String> SHAREPOINTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SharePointVersion").build();
    private static final MarshallingInfo<List> URLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Urls").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<Boolean> CRAWLATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlAttachments").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final MarshallingInfo<List> FIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldMappings").build();
    private static final SharePointConfigurationMarshaller instance = new SharePointConfigurationMarshaller();

    public static SharePointConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SharePointConfiguration sharePointConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sharePointConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sharePointConfiguration.getSharePointVersion(), SHAREPOINTVERSION_BINDING);
            protocolMarshaller.marshall(sharePointConfiguration.getUrls(), URLS_BINDING);
            protocolMarshaller.marshall((Object)sharePointConfiguration.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall((Object)sharePointConfiguration.getCrawlAttachments(), CRAWLATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)sharePointConfiguration.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
            protocolMarshaller.marshall(sharePointConfiguration.getFieldMappings(), FIELDMAPPINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

