/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.keyspaces.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateKeyspaceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyspaceName;
    private List<Tag> tags;

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public CreateKeyspaceRequest withKeyspaceName(String keyspaceName) {
        this.setKeyspaceName(keyspaceName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateKeyspaceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateKeyspaceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyspaceName() != null) {
            sb.append("KeyspaceName: ").append(this.getKeyspaceName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyspaceRequest)) {
            return false;
        }
        CreateKeyspaceRequest other = (CreateKeyspaceRequest)obj;
        if (other.getKeyspaceName() == null ^ this.getKeyspaceName() == null) {
            return false;
        }
        if (other.getKeyspaceName() != null && !other.getKeyspaceName().equals(this.getKeyspaceName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyspaceName() == null ? 0 : this.getKeyspaceName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateKeyspaceRequest clone() {
        return (CreateKeyspaceRequest)super.clone();
    }
}

