/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.LoadBalancer;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class LoadBalancerMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> DNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dnsName").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<List> PUBLICPORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicPorts").build();
    private static final MarshallingInfo<String> HEALTHCHECKPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("healthCheckPath").build();
    private static final MarshallingInfo<Integer> INSTANCEPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instancePort").build();
    private static final MarshallingInfo<List> INSTANCEHEALTHSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceHealthSummary").build();
    private static final MarshallingInfo<List> TLSCERTIFICATESUMMARIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tlsCertificateSummaries").build();
    private static final MarshallingInfo<Map> CONFIGURATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationOptions").build();
    private static final MarshallingInfo<String> IPADDRESSTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddressType").build();
    private static final MarshallingInfo<Boolean> HTTPSREDIRECTIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpsRedirectionEnabled").build();
    private static final MarshallingInfo<String> TLSPOLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tlsPolicyName").build();
    private static final LoadBalancerMarshaller instance = new LoadBalancerMarshaller();

    public static LoadBalancerMarshaller getInstance() {
        return instance;
    }

    public void marshall(LoadBalancer loadBalancer, ProtocolMarshaller protocolMarshaller) {
        if (loadBalancer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)loadBalancer.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getSupportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(loadBalancer.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getDnsName(), DNSNAME_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(loadBalancer.getPublicPorts(), PUBLICPORTS_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getHealthCheckPath(), HEALTHCHECKPATH_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getInstancePort(), INSTANCEPORT_BINDING);
            protocolMarshaller.marshall(loadBalancer.getInstanceHealthSummary(), INSTANCEHEALTHSUMMARY_BINDING);
            protocolMarshaller.marshall(loadBalancer.getTlsCertificateSummaries(), TLSCERTIFICATESUMMARIES_BINDING);
            protocolMarshaller.marshall(loadBalancer.getConfigurationOptions(), CONFIGURATIONOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getIpAddressType(), IPADDRESSTYPE_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getHttpsRedirectionEnabled(), HTTPSREDIRECTIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)loadBalancer.getTlsPolicyName(), TLSPOLICYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

