/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.EstimateByTime;
import com.amazonaws.services.lightsail.model.transform.CostEstimateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CostEstimate
implements Serializable,
Cloneable,
StructuredPojo {
    private String usageType;
    private List<EstimateByTime> resultsByTime;

    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    public String getUsageType() {
        return this.usageType;
    }

    public CostEstimate withUsageType(String usageType) {
        this.setUsageType(usageType);
        return this;
    }

    public List<EstimateByTime> getResultsByTime() {
        return this.resultsByTime;
    }

    public void setResultsByTime(Collection<EstimateByTime> resultsByTime) {
        if (resultsByTime == null) {
            this.resultsByTime = null;
            return;
        }
        this.resultsByTime = new ArrayList<EstimateByTime>(resultsByTime);
    }

    public CostEstimate withResultsByTime(EstimateByTime ... resultsByTime) {
        if (this.resultsByTime == null) {
            this.setResultsByTime(new ArrayList<EstimateByTime>(resultsByTime.length));
        }
        for (EstimateByTime ele : resultsByTime) {
            this.resultsByTime.add(ele);
        }
        return this;
    }

    public CostEstimate withResultsByTime(Collection<EstimateByTime> resultsByTime) {
        this.setResultsByTime(resultsByTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsageType() != null) {
            sb.append("UsageType: ").append(this.getUsageType()).append(",");
        }
        if (this.getResultsByTime() != null) {
            sb.append("ResultsByTime: ").append(this.getResultsByTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostEstimate)) {
            return false;
        }
        CostEstimate other = (CostEstimate)obj;
        if (other.getUsageType() == null ^ this.getUsageType() == null) {
            return false;
        }
        if (other.getUsageType() != null && !other.getUsageType().equals(this.getUsageType())) {
            return false;
        }
        if (other.getResultsByTime() == null ^ this.getResultsByTime() == null) {
            return false;
        }
        return other.getResultsByTime() == null || other.getResultsByTime().equals(this.getResultsByTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsageType() == null ? 0 : this.getUsageType().hashCode());
        hashCode = 31 * hashCode + (this.getResultsByTime() == null ? 0 : this.getResultsByTime().hashCode());
        return hashCode;
    }

    public CostEstimate clone() {
        try {
            return (CostEstimate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CostEstimateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

