/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.Bundle;
import java.util.List;

@SdkInternalApi
public class BundleMarshaller {
    private static final MarshallingInfo<Float> PRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("price").build();
    private static final MarshallingInfo<Integer> CPUCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpuCount").build();
    private static final MarshallingInfo<Integer> DISKSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskSizeInGb").build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").build();
    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Integer> POWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("power").build();
    private static final MarshallingInfo<Float> RAMSIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramSizeInGb").build();
    private static final MarshallingInfo<Integer> TRANSFERPERMONTHINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferPerMonthInGb").build();
    private static final MarshallingInfo<List> SUPPORTEDPLATFORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedPlatforms").build();
    private static final MarshallingInfo<List> SUPPORTEDAPPCATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedAppCategories").build();
    private static final BundleMarshaller instance = new BundleMarshaller();

    public static BundleMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bundle bundle, ProtocolMarshaller protocolMarshaller) {
        if (bundle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bundle.getPrice(), PRICE_BINDING);
            protocolMarshaller.marshall((Object)bundle.getCpuCount(), CPUCOUNT_BINDING);
            protocolMarshaller.marshall((Object)bundle.getDiskSizeInGb(), DISKSIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)bundle.getBundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)bundle.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)bundle.getIsActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall((Object)bundle.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)bundle.getPower(), POWER_BINDING);
            protocolMarshaller.marshall((Object)bundle.getRamSizeInGb(), RAMSIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)bundle.getTransferPerMonthInGb(), TRANSFERPERMONTHINGB_BINDING);
            protocolMarshaller.marshall(bundle.getSupportedPlatforms(), SUPPORTEDPLATFORMS_BINDING);
            protocolMarshaller.marshall(bundle.getSupportedAppCategories(), SUPPORTEDAPPCATEGORIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

