/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.Circle;
import java.util.List;

@SdkInternalApi
public class CircleMarshaller {
    private static final MarshallingInfo<List> CENTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Center").build();
    private static final MarshallingInfo<Double> RADIUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Radius").build();
    private static final CircleMarshaller instance = new CircleMarshaller();

    public static CircleMarshaller getInstance() {
        return instance;
    }

    public void marshall(Circle circle, ProtocolMarshaller protocolMarshaller) {
        if (circle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(circle.getCenter(), CENTER_BINDING);
            protocolMarshaller.marshall((Object)circle.getRadius(), RADIUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

