/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.ModifyGlobalClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyGlobalClusterRequestMarshaller
implements Marshaller<Request<ModifyGlobalClusterRequest>, ModifyGlobalClusterRequest> {
    public Request<ModifyGlobalClusterRequest> marshall(ModifyGlobalClusterRequest modifyGlobalClusterRequest) {
        if (modifyGlobalClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyGlobalClusterRequest, "AmazonNeptune");
        request.addParameter("Action", "ModifyGlobalCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyGlobalClusterRequest.getGlobalClusterIdentifier() != null) {
            request.addParameter("GlobalClusterIdentifier", StringUtils.fromString((String)modifyGlobalClusterRequest.getGlobalClusterIdentifier()));
        }
        if (modifyGlobalClusterRequest.getNewGlobalClusterIdentifier() != null) {
            request.addParameter("NewGlobalClusterIdentifier", StringUtils.fromString((String)modifyGlobalClusterRequest.getNewGlobalClusterIdentifier()));
        }
        if (modifyGlobalClusterRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)modifyGlobalClusterRequest.getDeletionProtection()));
        }
        if (modifyGlobalClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyGlobalClusterRequest.getEngineVersion()));
        }
        if (modifyGlobalClusterRequest.getAllowMajorVersionUpgrade() != null) {
            request.addParameter("AllowMajorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyGlobalClusterRequest.getAllowMajorVersionUpgrade()));
        }
        return request;
    }
}

