/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.EC2Capacity;

@SdkInternalApi
public class EC2CapacityMarshaller {
    private static final MarshallingInfo<String> FAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Family").build();
    private static final MarshallingInfo<String> MAXSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxSize").build();
    private static final MarshallingInfo<String> QUANTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quantity").build();
    private static final EC2CapacityMarshaller instance = new EC2CapacityMarshaller();

    public static EC2CapacityMarshaller getInstance() {
        return instance;
    }

    public void marshall(EC2Capacity eC2Capacity, ProtocolMarshaller protocolMarshaller) {
        if (eC2Capacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eC2Capacity.getFamily(), FAMILY_BINDING);
            protocolMarshaller.marshall((Object)eC2Capacity.getMaxSize(), MAXSIZE_BINDING);
            protocolMarshaller.marshall((Object)eC2Capacity.getQuantity(), QUANTITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

