/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.transform.StaticIpConnectionInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StaticIpConnectionInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String ipAddress;
    private String mask;
    private List<String> dns;
    private String defaultGateway;

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public StaticIpConnectionInfo withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    public StaticIpConnectionInfo withMask(String mask) {
        this.setMask(mask);
        return this;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public void setDns(Collection<String> dns) {
        if (dns == null) {
            this.dns = null;
            return;
        }
        this.dns = new ArrayList<String>(dns);
    }

    public StaticIpConnectionInfo withDns(String ... dns) {
        if (this.dns == null) {
            this.setDns(new ArrayList<String>(dns.length));
        }
        for (String ele : dns) {
            this.dns.add(ele);
        }
        return this;
    }

    public StaticIpConnectionInfo withDns(Collection<String> dns) {
        this.setDns(dns);
        return this;
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    public StaticIpConnectionInfo withDefaultGateway(String defaultGateway) {
        this.setDefaultGateway(defaultGateway);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getMask() != null) {
            sb.append("Mask: ").append(this.getMask()).append(",");
        }
        if (this.getDns() != null) {
            sb.append("Dns: ").append(this.getDns()).append(",");
        }
        if (this.getDefaultGateway() != null) {
            sb.append("DefaultGateway: ").append(this.getDefaultGateway());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticIpConnectionInfo)) {
            return false;
        }
        StaticIpConnectionInfo other = (StaticIpConnectionInfo)obj;
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getMask() == null ^ this.getMask() == null) {
            return false;
        }
        if (other.getMask() != null && !other.getMask().equals(this.getMask())) {
            return false;
        }
        if (other.getDns() == null ^ this.getDns() == null) {
            return false;
        }
        if (other.getDns() != null && !other.getDns().equals(this.getDns())) {
            return false;
        }
        if (other.getDefaultGateway() == null ^ this.getDefaultGateway() == null) {
            return false;
        }
        return other.getDefaultGateway() == null || other.getDefaultGateway().equals(this.getDefaultGateway());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getMask() == null ? 0 : this.getMask().hashCode());
        hashCode = 31 * hashCode + (this.getDns() == null ? 0 : this.getDns().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultGateway() == null ? 0 : this.getDefaultGateway().hashCode());
        return hashCode;
    }

    public StaticIpConnectionInfo clone() {
        try {
            return (StaticIpConnectionInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StaticIpConnectionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

