/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.panorama.model.NodeInterface;
import java.util.List;

@SdkInternalApi
public class NodeInterfaceMarshaller {
    private static final MarshallingInfo<List> INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Inputs").build();
    private static final MarshallingInfo<List> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();
    private static final NodeInterfaceMarshaller instance = new NodeInterfaceMarshaller();

    public static NodeInterfaceMarshaller getInstance() {
        return instance;
    }

    public void marshall(NodeInterface nodeInterface, ProtocolMarshaller protocolMarshaller) {
        if (nodeInterface == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(nodeInterface.getInputs(), INPUTS_BINDING);
            protocolMarshaller.marshall(nodeInterface.getOutputs(), OUTPUTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

