/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.APNSMessage;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class APNSMessageJsonUnmarshaller
implements Unmarshaller<APNSMessage, JsonUnmarshallerContext> {
    private static APNSMessageJsonUnmarshaller instance;

    public APNSMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        APNSMessage aPNSMessage = new APNSMessage();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setAction((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Badge", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setBadge((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setBody((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Category", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setCategory((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CollapseId", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setCollapseId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setData(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("MediaUrl", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setMediaUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PreferredAuthenticationMethod", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setPreferredAuthenticationMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Priority", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setPriority((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RawContent", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setRawContent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SilentPush", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setSilentPush((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sound", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setSound((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setSubstitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ThreadId", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setThreadId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TimeToLive", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setTimeToLive((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setTitle((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    aPNSMessage.setUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return aPNSMessage;
    }

    public static APNSMessageJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new APNSMessageJsonUnmarshaller();
        }
        return instance;
    }
}

