/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.EmailMessage;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class EmailMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> FEEDBACKFORWARDINGADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeedbackForwardingAddress").build();
    private static final MarshallingInfo<String> FROMADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromAddress").build();
    private static final MarshallingInfo<StructuredPojo> RAWEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RawEmail").build();
    private static final MarshallingInfo<List> REPLYTOADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplyToAddresses").build();
    private static final MarshallingInfo<StructuredPojo> SIMPLEEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimpleEmail").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final EmailMessageMarshaller instance = new EmailMessageMarshaller();

    public static EmailMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(EmailMessage emailMessage, ProtocolMarshaller protocolMarshaller) {
        if (emailMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)emailMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)emailMessage.getFeedbackForwardingAddress(), FEEDBACKFORWARDINGADDRESS_BINDING);
            protocolMarshaller.marshall((Object)emailMessage.getFromAddress(), FROMADDRESS_BINDING);
            protocolMarshaller.marshall((Object)emailMessage.getRawEmail(), RAWEMAIL_BINDING);
            protocolMarshaller.marshall(emailMessage.getReplyToAddresses(), REPLYTOADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)emailMessage.getSimpleEmail(), SIMPLEEMAIL_BINDING);
            protocolMarshaller.marshall(emailMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

