/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.GetSegmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetSegmentsRequestMarshaller
implements Marshaller<Request<GetSegmentsRequest>, GetSegmentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetSegmentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetSegmentsRequest> marshall(GetSegmentsRequest getSegmentsRequest) {
        if (getSegmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/segments";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getSegmentsRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        if (getSegmentsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentsRequest.getPageSize()));
        }
        if (getSegmentsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentsRequest.getToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

