/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.TreatmentResource;
import com.amazonaws.services.pinpoint.model.transform.CampaignStateJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.MessageConfigurationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.ScheduleJsonMarshaller;

public class TreatmentResourceJsonMarshaller {
    private static TreatmentResourceJsonMarshaller instance;

    public void marshall(TreatmentResource treatmentResource, StructuredJsonGenerator jsonGenerator) {
        if (treatmentResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (treatmentResource.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(treatmentResource.getId());
            }
            if (treatmentResource.getMessageConfiguration() != null) {
                jsonGenerator.writeFieldName("MessageConfiguration");
                MessageConfigurationJsonMarshaller.getInstance().marshall(treatmentResource.getMessageConfiguration(), jsonGenerator);
            }
            if (treatmentResource.getSchedule() != null) {
                jsonGenerator.writeFieldName("Schedule");
                ScheduleJsonMarshaller.getInstance().marshall(treatmentResource.getSchedule(), jsonGenerator);
            }
            if (treatmentResource.getSizePercent() != null) {
                jsonGenerator.writeFieldName("SizePercent").writeValue(treatmentResource.getSizePercent().intValue());
            }
            if (treatmentResource.getState() != null) {
                jsonGenerator.writeFieldName("State");
                CampaignStateJsonMarshaller.getInstance().marshall(treatmentResource.getState(), jsonGenerator);
            }
            if (treatmentResource.getTreatmentDescription() != null) {
                jsonGenerator.writeFieldName("TreatmentDescription").writeValue(treatmentResource.getTreatmentDescription());
            }
            if (treatmentResource.getTreatmentName() != null) {
                jsonGenerator.writeFieldName("TreatmentName").writeValue(treatmentResource.getTreatmentName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TreatmentResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TreatmentResourceJsonMarshaller();
        }
        return instance;
    }
}

