/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.VoiceMessage;
import java.util.Map;

@SdkInternalApi
public class VoiceMessageMarshaller {
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Body").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final MarshallingInfo<String> ORIGINATIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OriginationNumber").build();
    private static final MarshallingInfo<Map> SUBSTITUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Substitutions").build();
    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VoiceId").build();
    private static final VoiceMessageMarshaller instance = new VoiceMessageMarshaller();

    public static VoiceMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(VoiceMessage voiceMessage, ProtocolMarshaller protocolMarshaller) {
        if (voiceMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)voiceMessage.getBody(), BODY_BINDING);
            protocolMarshaller.marshall((Object)voiceMessage.getLanguageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)voiceMessage.getOriginationNumber(), ORIGINATIONNUMBER_BINDING);
            protocolMarshaller.marshall(voiceMessage.getSubstitutions(), SUBSTITUTIONS_BINDING);
            protocolMarshaller.marshall((Object)voiceMessage.getVoiceId(), VOICEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

