/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pipes.model.AwsVpcConfiguration;
import java.util.List;

@SdkInternalApi
public class AwsVpcConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroups").build();
    private static final MarshallingInfo<String> ASSIGNPUBLICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignPublicIp").build();
    private static final AwsVpcConfigurationMarshaller instance = new AwsVpcConfigurationMarshaller();

    public static AwsVpcConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AwsVpcConfiguration awsVpcConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (awsVpcConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(awsVpcConfiguration.getSubnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(awsVpcConfiguration.getSecurityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)awsVpcConfiguration.getAssignPublicIp(), ASSIGNPUBLICIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

