/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qldb.model.transform.KinesisConfigurationMarshaller;
import java.io.Serializable;

public class KinesisConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String streamArn;
    private Boolean aggregationEnabled;

    public void setStreamArn(String streamArn) {
        this.streamArn = streamArn;
    }

    public String getStreamArn() {
        return this.streamArn;
    }

    public KinesisConfiguration withStreamArn(String streamArn) {
        this.setStreamArn(streamArn);
        return this;
    }

    public void setAggregationEnabled(Boolean aggregationEnabled) {
        this.aggregationEnabled = aggregationEnabled;
    }

    public Boolean getAggregationEnabled() {
        return this.aggregationEnabled;
    }

    public KinesisConfiguration withAggregationEnabled(Boolean aggregationEnabled) {
        this.setAggregationEnabled(aggregationEnabled);
        return this;
    }

    public Boolean isAggregationEnabled() {
        return this.aggregationEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamArn() != null) {
            sb.append("StreamArn: ").append(this.getStreamArn()).append(",");
        }
        if (this.getAggregationEnabled() != null) {
            sb.append("AggregationEnabled: ").append(this.getAggregationEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisConfiguration)) {
            return false;
        }
        KinesisConfiguration other = (KinesisConfiguration)obj;
        if (other.getStreamArn() == null ^ this.getStreamArn() == null) {
            return false;
        }
        if (other.getStreamArn() != null && !other.getStreamArn().equals(this.getStreamArn())) {
            return false;
        }
        if (other.getAggregationEnabled() == null ^ this.getAggregationEnabled() == null) {
            return false;
        }
        return other.getAggregationEnabled() == null || other.getAggregationEnabled().equals(this.getAggregationEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamArn() == null ? 0 : this.getStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationEnabled() == null ? 0 : this.getAggregationEnabled().hashCode());
        return hashCode;
    }

    public KinesisConfiguration clone() {
        try {
            return (KinesisConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

