/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.TaggedResource;
import com.amazonaws.services.redshift.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TaggedResourceStaxUnmarshaller
implements Unmarshaller<TaggedResource, StaxUnmarshallerContext> {
    private static TaggedResourceStaxUnmarshaller instance;

    public TaggedResource unmarshall(StaxUnmarshallerContext context) throws Exception {
        TaggedResource taggedResource = new TaggedResource();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return taggedResource;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Tag", targetDepth)) {
                    taggedResource.setTag(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceName", targetDepth)) {
                    taggedResource.setResourceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceType", targetDepth)) continue;
                taggedResource.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return taggedResource;
    }

    public static TaggedResourceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TaggedResourceStaxUnmarshaller();
        }
        return instance;
    }
}

